// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataFactory.Models
{
    /// <summary> The authentication type to be used to connect to the FTP server. </summary>
    public readonly partial struct FtpAuthenticationType : IEquatable<FtpAuthenticationType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="FtpAuthenticationType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public FtpAuthenticationType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string BasicValue = "Basic";
        private const string AnonymousValue = "Anonymous";

        /// <summary> Basic. </summary>
        public static FtpAuthenticationType Basic { get; } = new FtpAuthenticationType(BasicValue);
        /// <summary> Anonymous. </summary>
        public static FtpAuthenticationType Anonymous { get; } = new FtpAuthenticationType(AnonymousValue);
        /// <summary> Determines if two <see cref="FtpAuthenticationType"/> values are the same. </summary>
        public static bool operator ==(FtpAuthenticationType left, FtpAuthenticationType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="FtpAuthenticationType"/> values are not the same. </summary>
        public static bool operator !=(FtpAuthenticationType left, FtpAuthenticationType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="FtpAuthenticationType"/>. </summary>
        public static implicit operator FtpAuthenticationType(string value) => new FtpAuthenticationType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is FtpAuthenticationType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(FtpAuthenticationType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
