// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataFactory.Models
{
    /// <summary> Client secret information for factory's bring your own app repository configuration. </summary>
    public partial class FactoryGitHubClientSecret
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="FactoryGitHubClientSecret"/>. </summary>
        public FactoryGitHubClientSecret()
        {
        }

        /// <summary> Initializes a new instance of <see cref="FactoryGitHubClientSecret"/>. </summary>
        /// <param name="byoaSecretAkvUri"> Bring your own app client secret AKV URL. </param>
        /// <param name="byoaSecretName"> Bring your own app client secret name in AKV. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal FactoryGitHubClientSecret(Uri byoaSecretAkvUri, string byoaSecretName, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ByoaSecretAkvUri = byoaSecretAkvUri;
            ByoaSecretName = byoaSecretName;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Bring your own app client secret AKV URL. </summary>
        public Uri ByoaSecretAkvUri { get; set; }
        /// <summary> Bring your own app client secret name in AKV. </summary>
        public string ByoaSecretName { get; set; }
    }
}
