// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataFactory.Models
{
    /// <summary> The custom setup of setting environment variable. </summary>
    public partial class EnvironmentVariableSetup : CustomSetupBase
    {
        /// <summary> Initializes a new instance of <see cref="EnvironmentVariableSetup"/>. </summary>
        /// <param name="variableName"> The name of the environment variable. </param>
        /// <param name="variableValue"> The value of the environment variable. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="variableName"/> or <paramref name="variableValue"/> is null. </exception>
        public EnvironmentVariableSetup(string variableName, string variableValue)
        {
            Argument.AssertNotNull(variableName, nameof(variableName));
            Argument.AssertNotNull(variableValue, nameof(variableValue));

            VariableName = variableName;
            VariableValue = variableValue;
            CustomSetupBaseType = "EnvironmentVariableSetup";
        }

        /// <summary> Initializes a new instance of <see cref="EnvironmentVariableSetup"/>. </summary>
        /// <param name="customSetupBaseType"> The type of custom setup. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="variableName"> The name of the environment variable. </param>
        /// <param name="variableValue"> The value of the environment variable. </param>
        internal EnvironmentVariableSetup(string customSetupBaseType, IDictionary<string, BinaryData> serializedAdditionalRawData, string variableName, string variableValue) : base(customSetupBaseType, serializedAdditionalRawData)
        {
            VariableName = variableName;
            VariableValue = variableValue;
            CustomSetupBaseType = customSetupBaseType ?? "EnvironmentVariableSetup";
        }

        /// <summary> Initializes a new instance of <see cref="EnvironmentVariableSetup"/> for deserialization. </summary>
        internal EnvironmentVariableSetup()
        {
        }

        /// <summary> The name of the environment variable. </summary>
        public string VariableName { get; set; }
        /// <summary> The value of the environment variable. </summary>
        public string VariableValue { get; set; }
    }
}
