// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataFactory.Models
{
    /// <summary> Parameter type. </summary>
    public readonly partial struct EntityParameterType : IEquatable<EntityParameterType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="EntityParameterType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public EntityParameterType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ObjectValue = "Object";
        private const string StringValue = "String";
        private const string IntValue = "Int";
        private const string FloatValue = "Float";
        private const string BoolValue = "Bool";
        private const string ArrayValue = "Array";
        private const string SecureStringValue = "SecureString";

        /// <summary> Object. </summary>
        public static EntityParameterType Object { get; } = new EntityParameterType(ObjectValue);
        /// <summary> String. </summary>
        public static EntityParameterType String { get; } = new EntityParameterType(StringValue);
        /// <summary> Int. </summary>
        public static EntityParameterType Int { get; } = new EntityParameterType(IntValue);
        /// <summary> Float. </summary>
        public static EntityParameterType Float { get; } = new EntityParameterType(FloatValue);
        /// <summary> Bool. </summary>
        public static EntityParameterType Bool { get; } = new EntityParameterType(BoolValue);
        /// <summary> Array. </summary>
        public static EntityParameterType Array { get; } = new EntityParameterType(ArrayValue);
        /// <summary> SecureString. </summary>
        public static EntityParameterType SecureString { get; } = new EntityParameterType(SecureStringValue);
        /// <summary> Determines if two <see cref="EntityParameterType"/> values are the same. </summary>
        public static bool operator ==(EntityParameterType left, EntityParameterType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="EntityParameterType"/> values are not the same. </summary>
        public static bool operator !=(EntityParameterType left, EntityParameterType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="EntityParameterType"/>. </summary>
        public static implicit operator EntityParameterType(string value) => new EntityParameterType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is EntityParameterType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(EntityParameterType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
