// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core.Expressions.DataFactory;

namespace Azure.ResourceManager.DataFactory.Models
{
    /// <summary> Distcp settings. </summary>
    public partial class DistcpSettings
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DistcpSettings"/>. </summary>
        /// <param name="resourceManagerEndpoint"> Specifies the Yarn ResourceManager endpoint. Type: string (or Expression with resultType string). </param>
        /// <param name="tempScriptPath"> Specifies an existing folder path which will be used to store temp Distcp command script. The script file is generated by ADF and will be removed after Copy job finished. Type: string (or Expression with resultType string). </param>
        /// <exception cref="ArgumentNullException"> <paramref name="resourceManagerEndpoint"/> or <paramref name="tempScriptPath"/> is null. </exception>
        public DistcpSettings(DataFactoryElement<string> resourceManagerEndpoint, DataFactoryElement<string> tempScriptPath)
        {
            Argument.AssertNotNull(resourceManagerEndpoint, nameof(resourceManagerEndpoint));
            Argument.AssertNotNull(tempScriptPath, nameof(tempScriptPath));

            ResourceManagerEndpoint = resourceManagerEndpoint;
            TempScriptPath = tempScriptPath;
        }

        /// <summary> Initializes a new instance of <see cref="DistcpSettings"/>. </summary>
        /// <param name="resourceManagerEndpoint"> Specifies the Yarn ResourceManager endpoint. Type: string (or Expression with resultType string). </param>
        /// <param name="tempScriptPath"> Specifies an existing folder path which will be used to store temp Distcp command script. The script file is generated by ADF and will be removed after Copy job finished. Type: string (or Expression with resultType string). </param>
        /// <param name="distcpOptions"> Specifies the Distcp options. Type: string (or Expression with resultType string). </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DistcpSettings(DataFactoryElement<string> resourceManagerEndpoint, DataFactoryElement<string> tempScriptPath, DataFactoryElement<string> distcpOptions, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ResourceManagerEndpoint = resourceManagerEndpoint;
            TempScriptPath = tempScriptPath;
            DistcpOptions = distcpOptions;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="DistcpSettings"/> for deserialization. </summary>
        internal DistcpSettings()
        {
        }

        /// <summary> Specifies the Yarn ResourceManager endpoint. Type: string (or Expression with resultType string). </summary>
        public DataFactoryElement<string> ResourceManagerEndpoint { get; set; }
        /// <summary> Specifies an existing folder path which will be used to store temp Distcp command script. The script file is generated by ADF and will be removed after Copy job finished. Type: string (or Expression with resultType string). </summary>
        public DataFactoryElement<string> TempScriptPath { get; set; }
        /// <summary> Specifies the Distcp options. Type: string (or Expression with resultType string). </summary>
        public DataFactoryElement<string> DistcpOptions { get; set; }
    }
}
