// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataFactory.Models
{
    /// <summary> Trigger run status. </summary>
    public readonly partial struct DataFactoryTriggerRunStatus : IEquatable<DataFactoryTriggerRunStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataFactoryTriggerRunStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataFactoryTriggerRunStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string InprogressValue = "Inprogress";

        /// <summary> Succeeded. </summary>
        public static DataFactoryTriggerRunStatus Succeeded { get; } = new DataFactoryTriggerRunStatus(SucceededValue);
        /// <summary> Failed. </summary>
        public static DataFactoryTriggerRunStatus Failed { get; } = new DataFactoryTriggerRunStatus(FailedValue);
        /// <summary> Inprogress. </summary>
        public static DataFactoryTriggerRunStatus Inprogress { get; } = new DataFactoryTriggerRunStatus(InprogressValue);
        /// <summary> Determines if two <see cref="DataFactoryTriggerRunStatus"/> values are the same. </summary>
        public static bool operator ==(DataFactoryTriggerRunStatus left, DataFactoryTriggerRunStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataFactoryTriggerRunStatus"/> values are not the same. </summary>
        public static bool operator !=(DataFactoryTriggerRunStatus left, DataFactoryTriggerRunStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataFactoryTriggerRunStatus"/>. </summary>
        public static implicit operator DataFactoryTriggerRunStatus(string value) => new DataFactoryTriggerRunStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataFactoryTriggerRunStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataFactoryTriggerRunStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
