// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataFactory.Models
{
    /// <summary> The type of the spark config. </summary>
    public readonly partial struct DataFactorySparkConfigurationType : IEquatable<DataFactorySparkConfigurationType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataFactorySparkConfigurationType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataFactorySparkConfigurationType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DefaultValue = "Default";
        private const string CustomizedValue = "Customized";
        private const string ArtifactValue = "Artifact";

        /// <summary> Default. </summary>
        public static DataFactorySparkConfigurationType Default { get; } = new DataFactorySparkConfigurationType(DefaultValue);
        /// <summary> Customized. </summary>
        public static DataFactorySparkConfigurationType Customized { get; } = new DataFactorySparkConfigurationType(CustomizedValue);
        /// <summary> Artifact. </summary>
        public static DataFactorySparkConfigurationType Artifact { get; } = new DataFactorySparkConfigurationType(ArtifactValue);
        /// <summary> Determines if two <see cref="DataFactorySparkConfigurationType"/> values are the same. </summary>
        public static bool operator ==(DataFactorySparkConfigurationType left, DataFactorySparkConfigurationType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataFactorySparkConfigurationType"/> values are not the same. </summary>
        public static bool operator !=(DataFactorySparkConfigurationType left, DataFactorySparkConfigurationType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataFactorySparkConfigurationType"/>. </summary>
        public static implicit operator DataFactorySparkConfigurationType(string value) => new DataFactorySparkConfigurationType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataFactorySparkConfigurationType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataFactorySparkConfigurationType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
