// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataFactory.Models
{
    /// <summary> The recurrence schedule occurrence. </summary>
    public partial class DataFactoryRecurrenceScheduleOccurrence
    {
        /// <summary> Initializes a new instance of <see cref="DataFactoryRecurrenceScheduleOccurrence"/>. </summary>
        public DataFactoryRecurrenceScheduleOccurrence()
        {
            AdditionalProperties = new ChangeTrackingDictionary<string, BinaryData>();
        }

        /// <summary> Initializes a new instance of <see cref="DataFactoryRecurrenceScheduleOccurrence"/>. </summary>
        /// <param name="day"> The day of the week. </param>
        /// <param name="occurrence"> The occurrence. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        internal DataFactoryRecurrenceScheduleOccurrence(DataFactoryDayOfWeek? day, int? occurrence, IDictionary<string, BinaryData> additionalProperties)
        {
            Day = day;
            Occurrence = occurrence;
            AdditionalProperties = additionalProperties;
        }

        /// <summary> The day of the week. </summary>
        public DataFactoryDayOfWeek? Day { get; set; }
        /// <summary> The occurrence. </summary>
        public int? Occurrence { get; set; }
        /// <summary>
        /// Additional Properties
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        public IDictionary<string, BinaryData> AdditionalProperties { get; }
    }
}
