// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataFactory.Models
{
    /// <summary> Enumerates possible frequency option for the schedule trigger. </summary>
    public readonly partial struct DataFactoryRecurrenceFrequency : IEquatable<DataFactoryRecurrenceFrequency>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataFactoryRecurrenceFrequency"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataFactoryRecurrenceFrequency(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotSpecifiedValue = "NotSpecified";
        private const string MinuteValue = "Minute";
        private const string HourValue = "Hour";
        private const string DayValue = "Day";
        private const string WeekValue = "Week";
        private const string MonthValue = "Month";
        private const string YearValue = "Year";

        /// <summary> NotSpecified. </summary>
        public static DataFactoryRecurrenceFrequency NotSpecified { get; } = new DataFactoryRecurrenceFrequency(NotSpecifiedValue);
        /// <summary> Minute. </summary>
        public static DataFactoryRecurrenceFrequency Minute { get; } = new DataFactoryRecurrenceFrequency(MinuteValue);
        /// <summary> Hour. </summary>
        public static DataFactoryRecurrenceFrequency Hour { get; } = new DataFactoryRecurrenceFrequency(HourValue);
        /// <summary> Day. </summary>
        public static DataFactoryRecurrenceFrequency Day { get; } = new DataFactoryRecurrenceFrequency(DayValue);
        /// <summary> Week. </summary>
        public static DataFactoryRecurrenceFrequency Week { get; } = new DataFactoryRecurrenceFrequency(WeekValue);
        /// <summary> Month. </summary>
        public static DataFactoryRecurrenceFrequency Month { get; } = new DataFactoryRecurrenceFrequency(MonthValue);
        /// <summary> Year. </summary>
        public static DataFactoryRecurrenceFrequency Year { get; } = new DataFactoryRecurrenceFrequency(YearValue);
        /// <summary> Determines if two <see cref="DataFactoryRecurrenceFrequency"/> values are the same. </summary>
        public static bool operator ==(DataFactoryRecurrenceFrequency left, DataFactoryRecurrenceFrequency right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataFactoryRecurrenceFrequency"/> values are not the same. </summary>
        public static bool operator !=(DataFactoryRecurrenceFrequency left, DataFactoryRecurrenceFrequency right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataFactoryRecurrenceFrequency"/>. </summary>
        public static implicit operator DataFactoryRecurrenceFrequency(string value) => new DataFactoryRecurrenceFrequency(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataFactoryRecurrenceFrequency other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataFactoryRecurrenceFrequency other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
