// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataFactory.Models
{
    /// <summary> A managed Virtual Network associated with the Azure Data Factory. </summary>
    public partial class DataFactoryManagedVirtualNetworkProperties
    {
        /// <summary> Initializes a new instance of <see cref="DataFactoryManagedVirtualNetworkProperties"/>. </summary>
        public DataFactoryManagedVirtualNetworkProperties()
        {
            AdditionalProperties = new ChangeTrackingDictionary<string, BinaryData>();
        }

        /// <summary> Initializes a new instance of <see cref="DataFactoryManagedVirtualNetworkProperties"/>. </summary>
        /// <param name="vnetId"> Managed Virtual Network ID. </param>
        /// <param name="alias"> Managed Virtual Network alias. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        internal DataFactoryManagedVirtualNetworkProperties(Guid? vnetId, string @alias, IDictionary<string, BinaryData> additionalProperties)
        {
            VnetId = vnetId;
            Alias = @alias;
            AdditionalProperties = additionalProperties;
        }

        /// <summary> Managed Virtual Network ID. </summary>
        public Guid? VnetId { get; }
        /// <summary> Managed Virtual Network alias. </summary>
        public string Alias { get; }
        /// <summary>
        /// Additional Properties
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        public IDictionary<string, BinaryData> AdditionalProperties { get; }
    }
}
