// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.DataFactory.Models
{
    /// <summary> Managed identity credential. </summary>
    public partial class DataFactoryManagedIdentityCredentialProperties : DataFactoryCredential
    {
        /// <summary> Initializes a new instance of <see cref="DataFactoryManagedIdentityCredentialProperties"/>. </summary>
        public DataFactoryManagedIdentityCredentialProperties()
        {
            CredentialType = "ManagedIdentity";
        }

        /// <summary> Initializes a new instance of <see cref="DataFactoryManagedIdentityCredentialProperties"/>. </summary>
        /// <param name="credentialType"> Type of credential. </param>
        /// <param name="description"> Credential description. </param>
        /// <param name="annotations"> List of tags that can be used for describing the Credential. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="resourceId"> The resource id of user assigned managed identity. </param>
        internal DataFactoryManagedIdentityCredentialProperties(string credentialType, string description, IList<BinaryData> annotations, IDictionary<string, BinaryData> additionalProperties, ResourceIdentifier resourceId) : base(credentialType, description, annotations, additionalProperties)
        {
            ResourceId = resourceId;
            CredentialType = credentialType ?? "ManagedIdentity";
        }

        /// <summary> The resource id of user assigned managed identity. </summary>
        public ResourceIdentifier ResourceId { get; set; }
    }
}
