// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataFactory.Models
{
    /// <summary> Integration runtime debug resource. </summary>
    public partial class DataFactoryIntegrationRuntimeDebugInfo : DataFactoryDebugInfo
    {
        /// <summary> Initializes a new instance of <see cref="DataFactoryIntegrationRuntimeDebugInfo"/>. </summary>
        /// <param name="properties">
        /// Integration runtime properties.
        /// Please note <see cref="DataFactoryIntegrationRuntimeProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="ManagedIntegrationRuntime"/> and <see cref="SelfHostedIntegrationRuntime"/>.
        /// </param>
        /// <exception cref="ArgumentNullException"> <paramref name="properties"/> is null. </exception>
        public DataFactoryIntegrationRuntimeDebugInfo(DataFactoryIntegrationRuntimeProperties properties)
        {
            Argument.AssertNotNull(properties, nameof(properties));

            Properties = properties;
        }

        /// <summary> Initializes a new instance of <see cref="DataFactoryIntegrationRuntimeDebugInfo"/>. </summary>
        /// <param name="name"> The resource name. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="properties">
        /// Integration runtime properties.
        /// Please note <see cref="DataFactoryIntegrationRuntimeProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="ManagedIntegrationRuntime"/> and <see cref="SelfHostedIntegrationRuntime"/>.
        /// </param>
        internal DataFactoryIntegrationRuntimeDebugInfo(string name, IDictionary<string, BinaryData> serializedAdditionalRawData, DataFactoryIntegrationRuntimeProperties properties) : base(name, serializedAdditionalRawData)
        {
            Properties = properties;
        }

        /// <summary> Initializes a new instance of <see cref="DataFactoryIntegrationRuntimeDebugInfo"/> for deserialization. </summary>
        internal DataFactoryIntegrationRuntimeDebugInfo()
        {
        }

        /// <summary>
        /// Integration runtime properties.
        /// Please note <see cref="DataFactoryIntegrationRuntimeProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="ManagedIntegrationRuntime"/> and <see cref="SelfHostedIntegrationRuntime"/>.
        /// </summary>
        public DataFactoryIntegrationRuntimeProperties Properties { get; }
    }
}
