// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataFactory.Models
{
    /// <summary> Type of expressions supported by the system. Type: string. </summary>
    public readonly partial struct DataFactoryExpressionV2Type : IEquatable<DataFactoryExpressionV2Type>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataFactoryExpressionV2Type"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataFactoryExpressionV2Type(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ConstantValue = "Constant";
        private const string FieldValue = "Field";
        private const string UnaryValue = "Unary";
        private const string BinaryValue = "Binary";
        private const string NAryValue = "NAry";

        /// <summary> Constant. </summary>
        public static DataFactoryExpressionV2Type Constant { get; } = new DataFactoryExpressionV2Type(ConstantValue);
        /// <summary> Field. </summary>
        public static DataFactoryExpressionV2Type Field { get; } = new DataFactoryExpressionV2Type(FieldValue);
        /// <summary> Unary. </summary>
        public static DataFactoryExpressionV2Type Unary { get; } = new DataFactoryExpressionV2Type(UnaryValue);
        /// <summary> Binary. </summary>
        public static DataFactoryExpressionV2Type Binary { get; } = new DataFactoryExpressionV2Type(BinaryValue);
        /// <summary> NAry. </summary>
        public static DataFactoryExpressionV2Type NAry { get; } = new DataFactoryExpressionV2Type(NAryValue);
        /// <summary> Determines if two <see cref="DataFactoryExpressionV2Type"/> values are the same. </summary>
        public static bool operator ==(DataFactoryExpressionV2Type left, DataFactoryExpressionV2Type right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataFactoryExpressionV2Type"/> values are not the same. </summary>
        public static bool operator !=(DataFactoryExpressionV2Type left, DataFactoryExpressionV2Type right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataFactoryExpressionV2Type"/>. </summary>
        public static implicit operator DataFactoryExpressionV2Type(string value) => new DataFactoryExpressionV2Type(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataFactoryExpressionV2Type other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataFactoryExpressionV2Type other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
