// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataFactory.Models
{
    /// <summary> Get Data Plane read only token response definition. </summary>
    public partial class DataFactoryDataPlaneAccessPolicyResult
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DataFactoryDataPlaneAccessPolicyResult"/>. </summary>
        internal DataFactoryDataPlaneAccessPolicyResult()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DataFactoryDataPlaneAccessPolicyResult"/>. </summary>
        /// <param name="policy"> The user access policy. </param>
        /// <param name="accessToken"> Data Plane read only access token. </param>
        /// <param name="dataPlaneUri"> Data Plane service base URL. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DataFactoryDataPlaneAccessPolicyResult(DataFactoryDataPlaneUserAccessPolicy policy, string accessToken, Uri dataPlaneUri, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Policy = policy;
            AccessToken = accessToken;
            DataPlaneUri = dataPlaneUri;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The user access policy. </summary>
        public DataFactoryDataPlaneUserAccessPolicy Policy { get; }
        /// <summary> Data Plane read only access token. </summary>
        public string AccessToken { get; }
        /// <summary> Data Plane service base URL. </summary>
        public Uri DataPlaneUri { get; }
    }
}
