// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataFactory.Models
{
    /// <summary> Response body structure of data flow result for data preview, statistics or expression preview. </summary>
    public partial class DataFactoryDataFlowDebugCommandResult
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DataFactoryDataFlowDebugCommandResult"/>. </summary>
        internal DataFactoryDataFlowDebugCommandResult()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DataFactoryDataFlowDebugCommandResult"/>. </summary>
        /// <param name="status"> The run status of data preview, statistics or expression preview. </param>
        /// <param name="data"> The result data of data preview, statistics or expression preview. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DataFactoryDataFlowDebugCommandResult(string status, string data, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Status = status;
            Data = data;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The run status of data preview, statistics or expression preview. </summary>
        public string Status { get; }
        /// <summary> The result data of data preview, statistics or expression preview. </summary>
        public string Data { get; }
    }
}
