// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataFactory.Models
{
    /// <summary> Credential reference type. </summary>
    public readonly partial struct DataFactoryCredentialReferenceType : IEquatable<DataFactoryCredentialReferenceType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataFactoryCredentialReferenceType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataFactoryCredentialReferenceType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CredentialReferenceValue = "CredentialReference";

        /// <summary> CredentialReference. </summary>
        public static DataFactoryCredentialReferenceType CredentialReference { get; } = new DataFactoryCredentialReferenceType(CredentialReferenceValue);
        /// <summary> Determines if two <see cref="DataFactoryCredentialReferenceType"/> values are the same. </summary>
        public static bool operator ==(DataFactoryCredentialReferenceType left, DataFactoryCredentialReferenceType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataFactoryCredentialReferenceType"/> values are not the same. </summary>
        public static bool operator !=(DataFactoryCredentialReferenceType left, DataFactoryCredentialReferenceType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataFactoryCredentialReferenceType"/>. </summary>
        public static implicit operator DataFactoryCredentialReferenceType(string value) => new DataFactoryCredentialReferenceType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataFactoryCredentialReferenceType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataFactoryCredentialReferenceType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
