// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core.Expressions.DataFactory;

namespace Azure.ResourceManager.DataFactory.Models
{
    /// <summary> Trigger that runs every time the selected Blob container changes. </summary>
    public partial class DataFactoryBlobTrigger : MultiplePipelineTrigger
    {
        /// <summary> Initializes a new instance of <see cref="DataFactoryBlobTrigger"/>. </summary>
        /// <param name="folderPath"> The path of the container/folder that will trigger the pipeline. </param>
        /// <param name="maxConcurrency"> The max number of parallel files to handle when it is triggered. </param>
        /// <param name="linkedService"> The Azure Storage linked service reference. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="folderPath"/> or <paramref name="linkedService"/> is null. </exception>
        public DataFactoryBlobTrigger(string folderPath, int maxConcurrency, DataFactoryLinkedServiceReference linkedService)
        {
            Argument.AssertNotNull(folderPath, nameof(folderPath));
            Argument.AssertNotNull(linkedService, nameof(linkedService));

            FolderPath = folderPath;
            MaxConcurrency = maxConcurrency;
            LinkedService = linkedService;
            TriggerType = "BlobTrigger";
        }

        /// <summary> Initializes a new instance of <see cref="DataFactoryBlobTrigger"/>. </summary>
        /// <param name="triggerType"> Trigger type. </param>
        /// <param name="description"> Trigger description. </param>
        /// <param name="runtimeState"> Indicates if trigger is running or not. Updated when Start/Stop APIs are called on the Trigger. </param>
        /// <param name="annotations"> List of tags that can be used for describing the trigger. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="pipelines"> Pipelines that need to be started. </param>
        /// <param name="folderPath"> The path of the container/folder that will trigger the pipeline. </param>
        /// <param name="maxConcurrency"> The max number of parallel files to handle when it is triggered. </param>
        /// <param name="linkedService"> The Azure Storage linked service reference. </param>
        internal DataFactoryBlobTrigger(string triggerType, string description, DataFactoryTriggerRuntimeState? runtimeState, IList<BinaryData> annotations, IDictionary<string, BinaryData> additionalProperties, IList<TriggerPipelineReference> pipelines, string folderPath, int maxConcurrency, DataFactoryLinkedServiceReference linkedService) : base(triggerType, description, runtimeState, annotations, additionalProperties, pipelines)
        {
            FolderPath = folderPath;
            MaxConcurrency = maxConcurrency;
            LinkedService = linkedService;
            TriggerType = triggerType ?? "BlobTrigger";
        }

        /// <summary> Initializes a new instance of <see cref="DataFactoryBlobTrigger"/> for deserialization. </summary>
        internal DataFactoryBlobTrigger()
        {
        }

        /// <summary> The path of the container/folder that will trigger the pipeline. </summary>
        public string FolderPath { get; set; }
        /// <summary> The max number of parallel files to handle when it is triggered. </summary>
        public int MaxConcurrency { get; set; }
        /// <summary> The Azure Storage linked service reference. </summary>
        public DataFactoryLinkedServiceReference LinkedService { get; set; }
    }
}
