// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataFactory.Models
{
    /// <summary> Custom linked service. </summary>
    public partial class CustomDataSourceLinkedService : DataFactoryLinkedServiceProperties
    {
        /// <summary> Initializes a new instance of <see cref="CustomDataSourceLinkedService"/>. </summary>
        /// <param name="typeProperties"> Custom linked service properties. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="typeProperties"/> is null. </exception>
        public CustomDataSourceLinkedService(BinaryData typeProperties)
        {
            Argument.AssertNotNull(typeProperties, nameof(typeProperties));

            TypeProperties = typeProperties;
            LinkedServiceType = "CustomDataSource";
        }

        /// <summary> Initializes a new instance of <see cref="CustomDataSourceLinkedService"/>. </summary>
        /// <param name="linkedServiceType"> Type of linked service. </param>
        /// <param name="linkedServiceVersion"> Version of the linked service. </param>
        /// <param name="connectVia"> The integration runtime reference. </param>
        /// <param name="description"> Linked service description. </param>
        /// <param name="parameters"> Parameters for linked service. </param>
        /// <param name="annotations"> List of tags that can be used for describing the linked service. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="typeProperties"> Custom linked service properties. </param>
        internal CustomDataSourceLinkedService(string linkedServiceType, string linkedServiceVersion, IntegrationRuntimeReference connectVia, string description, IDictionary<string, EntityParameterSpecification> parameters, IList<BinaryData> annotations, IDictionary<string, BinaryData> additionalProperties, BinaryData typeProperties) : base(linkedServiceType, linkedServiceVersion, connectVia, description, parameters, annotations, additionalProperties)
        {
            TypeProperties = typeProperties;
            LinkedServiceType = linkedServiceType ?? "CustomDataSource";
        }

        /// <summary> Initializes a new instance of <see cref="CustomDataSourceLinkedService"/> for deserialization. </summary>
        internal CustomDataSourceLinkedService()
        {
        }

        /// <summary>
        /// Custom linked service properties.
        /// <para>
        /// To assign an object to this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        public BinaryData TypeProperties { get; set; }
    }
}
