// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.DataFactory.Models
{
    /// <summary> The linked integration runtime information. </summary>
    public partial class CreateLinkedIntegrationRuntimeContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="CreateLinkedIntegrationRuntimeContent"/>. </summary>
        public CreateLinkedIntegrationRuntimeContent()
        {
        }

        /// <summary> Initializes a new instance of <see cref="CreateLinkedIntegrationRuntimeContent"/>. </summary>
        /// <param name="name"> The name of the linked integration runtime. </param>
        /// <param name="subscriptionId"> The ID of the subscription that the linked integration runtime belongs to. </param>
        /// <param name="dataFactoryName"> The name of the data factory that the linked integration runtime belongs to. </param>
        /// <param name="dataFactoryLocation"> The location of the data factory that the linked integration runtime belongs to. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal CreateLinkedIntegrationRuntimeContent(string name, string subscriptionId, string dataFactoryName, AzureLocation? dataFactoryLocation, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            SubscriptionId = subscriptionId;
            DataFactoryName = dataFactoryName;
            DataFactoryLocation = dataFactoryLocation;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The name of the linked integration runtime. </summary>
        public string Name { get; set; }
        /// <summary> The ID of the subscription that the linked integration runtime belongs to. </summary>
        public string SubscriptionId { get; set; }
        /// <summary> The name of the data factory that the linked integration runtime belongs to. </summary>
        public string DataFactoryName { get; set; }
        /// <summary> The location of the data factory that the linked integration runtime belongs to. </summary>
        public AzureLocation? DataFactoryLocation { get; set; }
    }
}
