// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataFactory.Models
{
    /// <summary> The connection mode used to access CosmosDB account. Type: string. </summary>
    public readonly partial struct CosmosDBConnectionMode : IEquatable<CosmosDBConnectionMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CosmosDBConnectionMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CosmosDBConnectionMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string GatewayValue = "Gateway";
        private const string DirectValue = "Direct";

        /// <summary> Gateway. </summary>
        public static CosmosDBConnectionMode Gateway { get; } = new CosmosDBConnectionMode(GatewayValue);
        /// <summary> Direct. </summary>
        public static CosmosDBConnectionMode Direct { get; } = new CosmosDBConnectionMode(DirectValue);
        /// <summary> Determines if two <see cref="CosmosDBConnectionMode"/> values are the same. </summary>
        public static bool operator ==(CosmosDBConnectionMode left, CosmosDBConnectionMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CosmosDBConnectionMode"/> values are not the same. </summary>
        public static bool operator !=(CosmosDBConnectionMode left, CosmosDBConnectionMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CosmosDBConnectionMode"/>. </summary>
        public static implicit operator CosmosDBConnectionMode(string value) => new CosmosDBConnectionMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CosmosDBConnectionMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CosmosDBConnectionMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
