// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataFactory.Models
{
    /// <summary> The connection state of a managed private endpoint. </summary>
    public partial class ConnectionStateProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ConnectionStateProperties"/>. </summary>
        public ConnectionStateProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ConnectionStateProperties"/>. </summary>
        /// <param name="actionsRequired"> The actions required on the managed private endpoint. </param>
        /// <param name="description"> The managed private endpoint description. </param>
        /// <param name="status"> The approval status. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ConnectionStateProperties(string actionsRequired, string description, string status, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ActionsRequired = actionsRequired;
            Description = description;
            Status = status;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The actions required on the managed private endpoint. </summary>
        public string ActionsRequired { get; }
        /// <summary> The managed private endpoint description. </summary>
        public string Description { get; }
        /// <summary> The approval status. </summary>
        public string Status { get; }
    }
}
