// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core.Expressions.DataFactory;

namespace Azure.ResourceManager.DataFactory.Models
{
    /// <summary> The custom setup of running cmdkey commands. </summary>
    public partial class CmdkeySetup : CustomSetupBase
    {
        /// <summary> Initializes a new instance of <see cref="CmdkeySetup"/>. </summary>
        /// <param name="targetName"> The server name of data source access. Type: string. </param>
        /// <param name="userName"> The user name of data source access. Type: string. </param>
        /// <param name="password"> The password of data source access. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="targetName"/>, <paramref name="userName"/> or <paramref name="password"/> is null. </exception>
        public CmdkeySetup(DataFactoryElement<string> targetName, DataFactoryElement<string> userName, DataFactorySecret password)
        {
            Argument.AssertNotNull(targetName, nameof(targetName));
            Argument.AssertNotNull(userName, nameof(userName));
            Argument.AssertNotNull(password, nameof(password));

            TargetName = targetName;
            UserName = userName;
            Password = password;
            CustomSetupBaseType = "CmdkeySetup";
        }

        /// <summary> Initializes a new instance of <see cref="CmdkeySetup"/>. </summary>
        /// <param name="customSetupBaseType"> The type of custom setup. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="targetName"> The server name of data source access. Type: string. </param>
        /// <param name="userName"> The user name of data source access. Type: string. </param>
        /// <param name="password"> The password of data source access. </param>
        internal CmdkeySetup(string customSetupBaseType, IDictionary<string, BinaryData> serializedAdditionalRawData, DataFactoryElement<string> targetName, DataFactoryElement<string> userName, DataFactorySecret password) : base(customSetupBaseType, serializedAdditionalRawData)
        {
            TargetName = targetName;
            UserName = userName;
            Password = password;
            CustomSetupBaseType = customSetupBaseType ?? "CmdkeySetup";
        }

        /// <summary> Initializes a new instance of <see cref="CmdkeySetup"/> for deserialization. </summary>
        internal CmdkeySetup()
        {
        }

        /// <summary> The server name of data source access. Type: string. </summary>
        public DataFactoryElement<string> TargetName { get; set; }
        /// <summary> The user name of data source access. Type: string. </summary>
        public DataFactoryElement<string> UserName { get; set; }
        /// <summary> The password of data source access. </summary>
        public DataFactorySecret Password { get; set; }
    }
}
