// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataFactory.Models
{
    /// <summary> The consistency level specifies how many Cassandra servers must respond to a read request before returning data to the client application. Cassandra checks the specified number of Cassandra servers for data to satisfy the read request. Must be one of cassandraSourceReadConsistencyLevels. The default value is 'ONE'. It is case-insensitive. </summary>
    public readonly partial struct CassandraSourceReadConsistencyLevel : IEquatable<CassandraSourceReadConsistencyLevel>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CassandraSourceReadConsistencyLevel"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CassandraSourceReadConsistencyLevel(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AllValue = "ALL";
        private const string EachQuorumValue = "EACH_QUORUM";
        private const string QuorumValue = "QUORUM";
        private const string LocalQuorumValue = "LOCAL_QUORUM";
        private const string OneValue = "ONE";
        private const string TwoValue = "TWO";
        private const string ThreeValue = "THREE";
        private const string LocalOneValue = "LOCAL_ONE";
        private const string SerialValue = "SERIAL";
        private const string LocalSerialValue = "LOCAL_SERIAL";

        /// <summary> ALL. </summary>
        public static CassandraSourceReadConsistencyLevel All { get; } = new CassandraSourceReadConsistencyLevel(AllValue);
        /// <summary> EACH_QUORUM. </summary>
        public static CassandraSourceReadConsistencyLevel EachQuorum { get; } = new CassandraSourceReadConsistencyLevel(EachQuorumValue);
        /// <summary> QUORUM. </summary>
        public static CassandraSourceReadConsistencyLevel Quorum { get; } = new CassandraSourceReadConsistencyLevel(QuorumValue);
        /// <summary> LOCAL_QUORUM. </summary>
        public static CassandraSourceReadConsistencyLevel LocalQuorum { get; } = new CassandraSourceReadConsistencyLevel(LocalQuorumValue);
        /// <summary> ONE. </summary>
        public static CassandraSourceReadConsistencyLevel One { get; } = new CassandraSourceReadConsistencyLevel(OneValue);
        /// <summary> TWO. </summary>
        public static CassandraSourceReadConsistencyLevel Two { get; } = new CassandraSourceReadConsistencyLevel(TwoValue);
        /// <summary> THREE. </summary>
        public static CassandraSourceReadConsistencyLevel Three { get; } = new CassandraSourceReadConsistencyLevel(ThreeValue);
        /// <summary> LOCAL_ONE. </summary>
        public static CassandraSourceReadConsistencyLevel LocalOne { get; } = new CassandraSourceReadConsistencyLevel(LocalOneValue);
        /// <summary> SERIAL. </summary>
        public static CassandraSourceReadConsistencyLevel Serial { get; } = new CassandraSourceReadConsistencyLevel(SerialValue);
        /// <summary> LOCAL_SERIAL. </summary>
        public static CassandraSourceReadConsistencyLevel LocalSerial { get; } = new CassandraSourceReadConsistencyLevel(LocalSerialValue);
        /// <summary> Determines if two <see cref="CassandraSourceReadConsistencyLevel"/> values are the same. </summary>
        public static bool operator ==(CassandraSourceReadConsistencyLevel left, CassandraSourceReadConsistencyLevel right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CassandraSourceReadConsistencyLevel"/> values are not the same. </summary>
        public static bool operator !=(CassandraSourceReadConsistencyLevel left, CassandraSourceReadConsistencyLevel right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CassandraSourceReadConsistencyLevel"/>. </summary>
        public static implicit operator CassandraSourceReadConsistencyLevel(string value) => new CassandraSourceReadConsistencyLevel(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CassandraSourceReadConsistencyLevel other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CassandraSourceReadConsistencyLevel other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
