// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataFactory.Models
{
    /// <summary> The type used for authentication. Type: string. </summary>
    public readonly partial struct AzureSqlMIAuthenticationType : IEquatable<AzureSqlMIAuthenticationType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AzureSqlMIAuthenticationType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AzureSqlMIAuthenticationType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SqlValue = "SQL";
        private const string ServicePrincipalValue = "ServicePrincipal";
        private const string SystemAssignedManagedIdentityValue = "SystemAssignedManagedIdentity";
        private const string UserAssignedManagedIdentityValue = "UserAssignedManagedIdentity";

        /// <summary> SQL. </summary>
        public static AzureSqlMIAuthenticationType Sql { get; } = new AzureSqlMIAuthenticationType(SqlValue);
        /// <summary> ServicePrincipal. </summary>
        public static AzureSqlMIAuthenticationType ServicePrincipal { get; } = new AzureSqlMIAuthenticationType(ServicePrincipalValue);
        /// <summary> SystemAssignedManagedIdentity. </summary>
        public static AzureSqlMIAuthenticationType SystemAssignedManagedIdentity { get; } = new AzureSqlMIAuthenticationType(SystemAssignedManagedIdentityValue);
        /// <summary> UserAssignedManagedIdentity. </summary>
        public static AzureSqlMIAuthenticationType UserAssignedManagedIdentity { get; } = new AzureSqlMIAuthenticationType(UserAssignedManagedIdentityValue);
        /// <summary> Determines if two <see cref="AzureSqlMIAuthenticationType"/> values are the same. </summary>
        public static bool operator ==(AzureSqlMIAuthenticationType left, AzureSqlMIAuthenticationType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AzureSqlMIAuthenticationType"/> values are not the same. </summary>
        public static bool operator !=(AzureSqlMIAuthenticationType left, AzureSqlMIAuthenticationType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AzureSqlMIAuthenticationType"/>. </summary>
        public static implicit operator AzureSqlMIAuthenticationType(string value) => new AzureSqlMIAuthenticationType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AzureSqlMIAuthenticationType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AzureSqlMIAuthenticationType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
