// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataFactory.Models
{
    /// <summary> The type used for authentication. Type: string. </summary>
    public readonly partial struct AzureSqlDatabaseAuthenticationType : IEquatable<AzureSqlDatabaseAuthenticationType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AzureSqlDatabaseAuthenticationType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AzureSqlDatabaseAuthenticationType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SqlValue = "SQL";
        private const string ServicePrincipalValue = "ServicePrincipal";
        private const string SystemAssignedManagedIdentityValue = "SystemAssignedManagedIdentity";
        private const string UserAssignedManagedIdentityValue = "UserAssignedManagedIdentity";

        /// <summary> SQL. </summary>
        public static AzureSqlDatabaseAuthenticationType Sql { get; } = new AzureSqlDatabaseAuthenticationType(SqlValue);
        /// <summary> ServicePrincipal. </summary>
        public static AzureSqlDatabaseAuthenticationType ServicePrincipal { get; } = new AzureSqlDatabaseAuthenticationType(ServicePrincipalValue);
        /// <summary> SystemAssignedManagedIdentity. </summary>
        public static AzureSqlDatabaseAuthenticationType SystemAssignedManagedIdentity { get; } = new AzureSqlDatabaseAuthenticationType(SystemAssignedManagedIdentityValue);
        /// <summary> UserAssignedManagedIdentity. </summary>
        public static AzureSqlDatabaseAuthenticationType UserAssignedManagedIdentity { get; } = new AzureSqlDatabaseAuthenticationType(UserAssignedManagedIdentityValue);
        /// <summary> Determines if two <see cref="AzureSqlDatabaseAuthenticationType"/> values are the same. </summary>
        public static bool operator ==(AzureSqlDatabaseAuthenticationType left, AzureSqlDatabaseAuthenticationType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AzureSqlDatabaseAuthenticationType"/> values are not the same. </summary>
        public static bool operator !=(AzureSqlDatabaseAuthenticationType left, AzureSqlDatabaseAuthenticationType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AzureSqlDatabaseAuthenticationType"/>. </summary>
        public static implicit operator AzureSqlDatabaseAuthenticationType(string value) => new AzureSqlDatabaseAuthenticationType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AzureSqlDatabaseAuthenticationType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AzureSqlDatabaseAuthenticationType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
