// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core.Expressions.DataFactory;

namespace Azure.ResourceManager.DataFactory.Models
{
    /// <summary> Azure Databricks Delta Lake export command settings. </summary>
    public partial class AzureDatabricksDeltaLakeExportCommand : ExportSettings
    {
        /// <summary> Initializes a new instance of <see cref="AzureDatabricksDeltaLakeExportCommand"/>. </summary>
        public AzureDatabricksDeltaLakeExportCommand()
        {
            ExportSettingsType = "AzureDatabricksDeltaLakeExportCommand";
        }

        /// <summary> Initializes a new instance of <see cref="AzureDatabricksDeltaLakeExportCommand"/>. </summary>
        /// <param name="exportSettingsType"> The export setting type. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="dateFormat"> Specify the date format for the csv in Azure Databricks Delta Lake Copy. Type: string (or Expression with resultType string). </param>
        /// <param name="timestampFormat"> Specify the timestamp format for the csv in Azure Databricks Delta Lake Copy. Type: string (or Expression with resultType string). </param>
        internal AzureDatabricksDeltaLakeExportCommand(string exportSettingsType, IDictionary<string, BinaryData> additionalProperties, DataFactoryElement<string> dateFormat, DataFactoryElement<string> timestampFormat) : base(exportSettingsType, additionalProperties)
        {
            DateFormat = dateFormat;
            TimestampFormat = timestampFormat;
            ExportSettingsType = exportSettingsType ?? "AzureDatabricksDeltaLakeExportCommand";
        }

        /// <summary> Specify the date format for the csv in Azure Databricks Delta Lake Copy. Type: string (or Expression with resultType string). </summary>
        public DataFactoryElement<string> DateFormat { get; set; }
        /// <summary> Specify the timestamp format for the csv in Azure Databricks Delta Lake Copy. Type: string (or Expression with resultType string). </summary>
        public DataFactoryElement<string> TimestampFormat { get; set; }
    }
}
