// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataFactory.Models
{
    /// <summary> The type used for authentication. Type: string. </summary>
    public readonly partial struct AmazonRdsForSqlAuthenticationType : IEquatable<AmazonRdsForSqlAuthenticationType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AmazonRdsForSqlAuthenticationType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AmazonRdsForSqlAuthenticationType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SqlValue = "SQL";
        private const string WindowsValue = "Windows";

        /// <summary> SQL. </summary>
        public static AmazonRdsForSqlAuthenticationType Sql { get; } = new AmazonRdsForSqlAuthenticationType(SqlValue);
        /// <summary> Windows. </summary>
        public static AmazonRdsForSqlAuthenticationType Windows { get; } = new AmazonRdsForSqlAuthenticationType(WindowsValue);
        /// <summary> Determines if two <see cref="AmazonRdsForSqlAuthenticationType"/> values are the same. </summary>
        public static bool operator ==(AmazonRdsForSqlAuthenticationType left, AmazonRdsForSqlAuthenticationType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AmazonRdsForSqlAuthenticationType"/> values are not the same. </summary>
        public static bool operator !=(AmazonRdsForSqlAuthenticationType left, AmazonRdsForSqlAuthenticationType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AmazonRdsForSqlAuthenticationType"/>. </summary>
        public static implicit operator AmazonRdsForSqlAuthenticationType(string value) => new AmazonRdsForSqlAuthenticationType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AmazonRdsForSqlAuthenticationType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AmazonRdsForSqlAuthenticationType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
