// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.DataFactory
{
    /// <summary>
    /// A class representing a collection of <see cref="DataFactoryChangeDataCaptureResource"/> and their operations.
    /// Each <see cref="DataFactoryChangeDataCaptureResource"/> in the collection will belong to the same instance of <see cref="DataFactoryResource"/>.
    /// To get a <see cref="DataFactoryChangeDataCaptureCollection"/> instance call the GetDataFactoryChangeDataCaptures method from an instance of <see cref="DataFactoryResource"/>.
    /// </summary>
    public partial class DataFactoryChangeDataCaptureCollection : ArmCollection, IEnumerable<DataFactoryChangeDataCaptureResource>, IAsyncEnumerable<DataFactoryChangeDataCaptureResource>
    {
        private readonly ClientDiagnostics _dataFactoryChangeDataCaptureChangeDataCaptureClientDiagnostics;
        private readonly ChangeDataCaptureRestOperations _dataFactoryChangeDataCaptureChangeDataCaptureRestClient;

        /// <summary> Initializes a new instance of the <see cref="DataFactoryChangeDataCaptureCollection"/> class for mocking. </summary>
        protected DataFactoryChangeDataCaptureCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="DataFactoryChangeDataCaptureCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal DataFactoryChangeDataCaptureCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _dataFactoryChangeDataCaptureChangeDataCaptureClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.DataFactory", DataFactoryChangeDataCaptureResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(DataFactoryChangeDataCaptureResource.ResourceType, out string dataFactoryChangeDataCaptureChangeDataCaptureApiVersion);
            _dataFactoryChangeDataCaptureChangeDataCaptureRestClient = new ChangeDataCaptureRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, dataFactoryChangeDataCaptureChangeDataCaptureApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != DataFactoryResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, DataFactoryResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Creates or updates a change data capture resource.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/adfcdcs/{changeDataCaptureName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ChangeDataCapture_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2018-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DataFactoryChangeDataCaptureResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="changeDataCaptureName"> The change data capture name. </param>
        /// <param name="data"> Change data capture resource definition. </param>
        /// <param name="ifMatch"> ETag of the change data capture entity. Should only be specified for update, for which it should match existing entity or can be * for unconditional update. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="changeDataCaptureName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="changeDataCaptureName"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<DataFactoryChangeDataCaptureResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string changeDataCaptureName, DataFactoryChangeDataCaptureData data, string ifMatch = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(changeDataCaptureName, nameof(changeDataCaptureName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _dataFactoryChangeDataCaptureChangeDataCaptureClientDiagnostics.CreateScope("DataFactoryChangeDataCaptureCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _dataFactoryChangeDataCaptureChangeDataCaptureRestClient.CreateOrUpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, changeDataCaptureName, data, ifMatch, cancellationToken).ConfigureAwait(false);
                var uri = _dataFactoryChangeDataCaptureChangeDataCaptureRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, changeDataCaptureName, data, ifMatch);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new DataFactoryArmOperation<DataFactoryChangeDataCaptureResource>(Response.FromValue(new DataFactoryChangeDataCaptureResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Creates or updates a change data capture resource.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/adfcdcs/{changeDataCaptureName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ChangeDataCapture_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2018-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DataFactoryChangeDataCaptureResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="changeDataCaptureName"> The change data capture name. </param>
        /// <param name="data"> Change data capture resource definition. </param>
        /// <param name="ifMatch"> ETag of the change data capture entity. Should only be specified for update, for which it should match existing entity or can be * for unconditional update. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="changeDataCaptureName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="changeDataCaptureName"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<DataFactoryChangeDataCaptureResource> CreateOrUpdate(WaitUntil waitUntil, string changeDataCaptureName, DataFactoryChangeDataCaptureData data, string ifMatch = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(changeDataCaptureName, nameof(changeDataCaptureName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _dataFactoryChangeDataCaptureChangeDataCaptureClientDiagnostics.CreateScope("DataFactoryChangeDataCaptureCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _dataFactoryChangeDataCaptureChangeDataCaptureRestClient.CreateOrUpdate(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, changeDataCaptureName, data, ifMatch, cancellationToken);
                var uri = _dataFactoryChangeDataCaptureChangeDataCaptureRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, changeDataCaptureName, data, ifMatch);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new DataFactoryArmOperation<DataFactoryChangeDataCaptureResource>(Response.FromValue(new DataFactoryChangeDataCaptureResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a change data capture.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/adfcdcs/{changeDataCaptureName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ChangeDataCapture_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2018-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DataFactoryChangeDataCaptureResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="changeDataCaptureName"> The change data capture name. </param>
        /// <param name="ifNoneMatch"> ETag of the change data capture entity. Should only be specified for get. If the ETag matches the existing entity tag, or if * was provided, then no content will be returned. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="changeDataCaptureName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="changeDataCaptureName"/> is null. </exception>
        public virtual async Task<Response<DataFactoryChangeDataCaptureResource>> GetAsync(string changeDataCaptureName, string ifNoneMatch = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(changeDataCaptureName, nameof(changeDataCaptureName));

            using var scope = _dataFactoryChangeDataCaptureChangeDataCaptureClientDiagnostics.CreateScope("DataFactoryChangeDataCaptureCollection.Get");
            scope.Start();
            try
            {
                var response = await _dataFactoryChangeDataCaptureChangeDataCaptureRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, changeDataCaptureName, ifNoneMatch, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new DataFactoryChangeDataCaptureResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a change data capture.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/adfcdcs/{changeDataCaptureName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ChangeDataCapture_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2018-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DataFactoryChangeDataCaptureResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="changeDataCaptureName"> The change data capture name. </param>
        /// <param name="ifNoneMatch"> ETag of the change data capture entity. Should only be specified for get. If the ETag matches the existing entity tag, or if * was provided, then no content will be returned. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="changeDataCaptureName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="changeDataCaptureName"/> is null. </exception>
        public virtual Response<DataFactoryChangeDataCaptureResource> Get(string changeDataCaptureName, string ifNoneMatch = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(changeDataCaptureName, nameof(changeDataCaptureName));

            using var scope = _dataFactoryChangeDataCaptureChangeDataCaptureClientDiagnostics.CreateScope("DataFactoryChangeDataCaptureCollection.Get");
            scope.Start();
            try
            {
                var response = _dataFactoryChangeDataCaptureChangeDataCaptureRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, changeDataCaptureName, ifNoneMatch, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new DataFactoryChangeDataCaptureResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Lists all resources of type change data capture.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/adfcdcs</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ChangeDataCapture_ListByFactory</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2018-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DataFactoryChangeDataCaptureResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="DataFactoryChangeDataCaptureResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<DataFactoryChangeDataCaptureResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _dataFactoryChangeDataCaptureChangeDataCaptureRestClient.CreateListByFactoryRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _dataFactoryChangeDataCaptureChangeDataCaptureRestClient.CreateListByFactoryNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new DataFactoryChangeDataCaptureResource(Client, DataFactoryChangeDataCaptureData.DeserializeDataFactoryChangeDataCaptureData(e)), _dataFactoryChangeDataCaptureChangeDataCaptureClientDiagnostics, Pipeline, "DataFactoryChangeDataCaptureCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Lists all resources of type change data capture.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/adfcdcs</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ChangeDataCapture_ListByFactory</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2018-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DataFactoryChangeDataCaptureResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="DataFactoryChangeDataCaptureResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<DataFactoryChangeDataCaptureResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _dataFactoryChangeDataCaptureChangeDataCaptureRestClient.CreateListByFactoryRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _dataFactoryChangeDataCaptureChangeDataCaptureRestClient.CreateListByFactoryNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new DataFactoryChangeDataCaptureResource(Client, DataFactoryChangeDataCaptureData.DeserializeDataFactoryChangeDataCaptureData(e)), _dataFactoryChangeDataCaptureChangeDataCaptureClientDiagnostics, Pipeline, "DataFactoryChangeDataCaptureCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/adfcdcs/{changeDataCaptureName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ChangeDataCapture_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2018-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DataFactoryChangeDataCaptureResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="changeDataCaptureName"> The change data capture name. </param>
        /// <param name="ifNoneMatch"> ETag of the change data capture entity. Should only be specified for get. If the ETag matches the existing entity tag, or if * was provided, then no content will be returned. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="changeDataCaptureName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="changeDataCaptureName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string changeDataCaptureName, string ifNoneMatch = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(changeDataCaptureName, nameof(changeDataCaptureName));

            using var scope = _dataFactoryChangeDataCaptureChangeDataCaptureClientDiagnostics.CreateScope("DataFactoryChangeDataCaptureCollection.Exists");
            scope.Start();
            try
            {
                var response = await _dataFactoryChangeDataCaptureChangeDataCaptureRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, changeDataCaptureName, ifNoneMatch, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/adfcdcs/{changeDataCaptureName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ChangeDataCapture_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2018-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DataFactoryChangeDataCaptureResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="changeDataCaptureName"> The change data capture name. </param>
        /// <param name="ifNoneMatch"> ETag of the change data capture entity. Should only be specified for get. If the ETag matches the existing entity tag, or if * was provided, then no content will be returned. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="changeDataCaptureName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="changeDataCaptureName"/> is null. </exception>
        public virtual Response<bool> Exists(string changeDataCaptureName, string ifNoneMatch = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(changeDataCaptureName, nameof(changeDataCaptureName));

            using var scope = _dataFactoryChangeDataCaptureChangeDataCaptureClientDiagnostics.CreateScope("DataFactoryChangeDataCaptureCollection.Exists");
            scope.Start();
            try
            {
                var response = _dataFactoryChangeDataCaptureChangeDataCaptureRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, changeDataCaptureName, ifNoneMatch, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/adfcdcs/{changeDataCaptureName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ChangeDataCapture_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2018-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DataFactoryChangeDataCaptureResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="changeDataCaptureName"> The change data capture name. </param>
        /// <param name="ifNoneMatch"> ETag of the change data capture entity. Should only be specified for get. If the ETag matches the existing entity tag, or if * was provided, then no content will be returned. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="changeDataCaptureName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="changeDataCaptureName"/> is null. </exception>
        public virtual async Task<NullableResponse<DataFactoryChangeDataCaptureResource>> GetIfExistsAsync(string changeDataCaptureName, string ifNoneMatch = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(changeDataCaptureName, nameof(changeDataCaptureName));

            using var scope = _dataFactoryChangeDataCaptureChangeDataCaptureClientDiagnostics.CreateScope("DataFactoryChangeDataCaptureCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _dataFactoryChangeDataCaptureChangeDataCaptureRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, changeDataCaptureName, ifNoneMatch, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<DataFactoryChangeDataCaptureResource>(response.GetRawResponse());
                return Response.FromValue(new DataFactoryChangeDataCaptureResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/adfcdcs/{changeDataCaptureName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ChangeDataCapture_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2018-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DataFactoryChangeDataCaptureResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="changeDataCaptureName"> The change data capture name. </param>
        /// <param name="ifNoneMatch"> ETag of the change data capture entity. Should only be specified for get. If the ETag matches the existing entity tag, or if * was provided, then no content will be returned. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="changeDataCaptureName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="changeDataCaptureName"/> is null. </exception>
        public virtual NullableResponse<DataFactoryChangeDataCaptureResource> GetIfExists(string changeDataCaptureName, string ifNoneMatch = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(changeDataCaptureName, nameof(changeDataCaptureName));

            using var scope = _dataFactoryChangeDataCaptureChangeDataCaptureClientDiagnostics.CreateScope("DataFactoryChangeDataCaptureCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _dataFactoryChangeDataCaptureChangeDataCaptureRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, changeDataCaptureName, ifNoneMatch, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<DataFactoryChangeDataCaptureResource>(response.GetRawResponse());
                return Response.FromValue(new DataFactoryChangeDataCaptureResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<DataFactoryChangeDataCaptureResource> IEnumerable<DataFactoryChangeDataCaptureResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<DataFactoryChangeDataCaptureResource> IAsyncEnumerable<DataFactoryChangeDataCaptureResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
