// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using Azure.Core;
using Azure.Core.Expressions.DataFactory;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.DataFactory.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class ArmDataFactoryModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="DataFactory.DataFactoryData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="identity"> Managed service identity of the factory. Current supported identity types: SystemAssigned, UserAssigned, SystemAssigned,UserAssigned. </param>
        /// <param name="provisioningState"> Factory provisioning state, example Succeeded. </param>
        /// <param name="createdOn"> Time the factory was created in ISO8601 format. </param>
        /// <param name="version"> Version of the factory. </param>
        /// <param name="purviewResourceId"> Purview information of the factory. </param>
        /// <param name="repoConfiguration">
        /// Git repo information of the factory.
        /// Please note <see cref="FactoryRepoConfiguration"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="FactoryGitHubConfiguration"/> and <see cref="FactoryVstsConfiguration"/>.
        /// </param>
        /// <param name="globalParameters"> List of parameters for factory. </param>
        /// <param name="encryption"> Properties to enable Customer Managed Key for the factory. </param>
        /// <param name="publicNetworkAccess"> Whether or not public network access is allowed for the data factory. </param>
        /// <param name="eTag"> Etag identifies change in the resource. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <returns> A new <see cref="DataFactory.DataFactoryData"/> instance for mocking. </returns>
        public static DataFactoryData DataFactoryData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, ManagedServiceIdentity identity = null, string provisioningState = null, DateTimeOffset? createdOn = null, string version = null, ResourceIdentifier purviewResourceId = null, FactoryRepoConfiguration repoConfiguration = null, IDictionary<string, DataFactoryGlobalParameterProperties> globalParameters = null, DataFactoryEncryptionConfiguration encryption = null, DataFactoryPublicNetworkAccess? publicNetworkAccess = null, ETag? eTag = null, IDictionary<string, BinaryData> additionalProperties = null)
        {
            tags ??= new Dictionary<string, string>();
            globalParameters ??= new Dictionary<string, DataFactoryGlobalParameterProperties>();
            additionalProperties ??= new Dictionary<string, BinaryData>();

            return new DataFactoryData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                identity,
                provisioningState,
                createdOn,
                version,
                purviewResourceId != null ? new DataFactoryPurviewConfiguration(purviewResourceId, serializedAdditionalRawData: null) : null,
                repoConfiguration,
                globalParameters,
                encryption,
                publicNetworkAccess,
                eTag,
                additionalProperties);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ExposureControlResult"/>. </summary>
        /// <param name="featureName"> The feature name. </param>
        /// <param name="value"> The feature value. </param>
        /// <returns> A new <see cref="Models.ExposureControlResult"/> instance for mocking. </returns>
        public static ExposureControlResult ExposureControlResult(string featureName = null, string value = null)
        {
            return new ExposureControlResult(featureName, value, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ExposureControlBatchResult"/>. </summary>
        /// <param name="exposureControlResults"> List of exposure control feature values. </param>
        /// <returns> A new <see cref="Models.ExposureControlBatchResult"/> instance for mocking. </returns>
        public static ExposureControlBatchResult ExposureControlBatchResult(IEnumerable<ExposureControlResult> exposureControlResults = null)
        {
            exposureControlResults ??= new List<ExposureControlResult>();

            return new ExposureControlBatchResult(exposureControlResults?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.GitHubAccessTokenContent"/>. </summary>
        /// <param name="gitHubAccessCode"> GitHub access code. </param>
        /// <param name="gitHubClientId"> GitHub application client ID. </param>
        /// <param name="gitHubClientSecret"> GitHub bring your own app client secret information. </param>
        /// <param name="gitHubAccessTokenBaseUri"> GitHub access token base URL. </param>
        /// <returns> A new <see cref="Models.GitHubAccessTokenContent"/> instance for mocking. </returns>
        public static GitHubAccessTokenContent GitHubAccessTokenContent(string gitHubAccessCode = null, string gitHubClientId = null, FactoryGitHubClientSecret gitHubClientSecret = null, Uri gitHubAccessTokenBaseUri = null)
        {
            return new GitHubAccessTokenContent(gitHubAccessCode, gitHubClientId, gitHubClientSecret, gitHubAccessTokenBaseUri, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.GitHubAccessTokenResult"/>. </summary>
        /// <param name="gitHubAccessToken"> GitHub access token. </param>
        /// <returns> A new <see cref="Models.GitHubAccessTokenResult"/> instance for mocking. </returns>
        public static GitHubAccessTokenResult GitHubAccessTokenResult(string gitHubAccessToken = null)
        {
            return new GitHubAccessTokenResult(gitHubAccessToken, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataFactoryDataPlaneAccessPolicyResult"/>. </summary>
        /// <param name="policy"> The user access policy. </param>
        /// <param name="accessToken"> Data Plane read only access token. </param>
        /// <param name="dataPlaneUri"> Data Plane service base URL. </param>
        /// <returns> A new <see cref="Models.DataFactoryDataPlaneAccessPolicyResult"/> instance for mocking. </returns>
        public static DataFactoryDataPlaneAccessPolicyResult DataFactoryDataPlaneAccessPolicyResult(DataFactoryDataPlaneUserAccessPolicy policy = null, string accessToken = null, Uri dataPlaneUri = null)
        {
            return new DataFactoryDataPlaneAccessPolicyResult(policy, accessToken, dataPlaneUri, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DataFactory.DataFactoryIntegrationRuntimeData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties">
        /// Integration runtime properties.
        /// Please note <see cref="DataFactoryIntegrationRuntimeProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.ManagedIntegrationRuntime"/> and <see cref="SelfHostedIntegrationRuntime"/>.
        /// </param>
        /// <param name="eTag"> Etag identifies change in the resource. </param>
        /// <returns> A new <see cref="DataFactory.DataFactoryIntegrationRuntimeData"/> instance for mocking. </returns>
        public static DataFactoryIntegrationRuntimeData DataFactoryIntegrationRuntimeData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, DataFactoryIntegrationRuntimeProperties properties = null, ETag? eTag = null)
        {
            return new DataFactoryIntegrationRuntimeData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                eTag,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataFactoryIntegrationRuntimeStatusResult"/>. </summary>
        /// <param name="name"> The integration runtime name. </param>
        /// <param name="properties">
        /// Integration runtime properties.
        /// Please note <see cref="Models.IntegrationRuntimeStatus"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.ManagedIntegrationRuntimeStatus"/> and <see cref="Models.SelfHostedIntegrationRuntimeStatus"/>.
        /// </param>
        /// <returns> A new <see cref="Models.DataFactoryIntegrationRuntimeStatusResult"/> instance for mocking. </returns>
        public static DataFactoryIntegrationRuntimeStatusResult DataFactoryIntegrationRuntimeStatusResult(string name = null, IntegrationRuntimeStatus properties = null)
        {
            return new DataFactoryIntegrationRuntimeStatusResult(name, properties, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.IntegrationRuntimeStatus"/>. </summary>
        /// <param name="runtimeType"> Type of integration runtime. </param>
        /// <param name="dataFactoryName"> The data factory name which the integration runtime belong to. </param>
        /// <param name="state"> The state of integration runtime. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <returns> A new <see cref="Models.IntegrationRuntimeStatus"/> instance for mocking. </returns>
        public static IntegrationRuntimeStatus IntegrationRuntimeStatus(string runtimeType = null, string dataFactoryName = null, IntegrationRuntimeState? state = null, IReadOnlyDictionary<string, BinaryData> additionalProperties = null)
        {
            additionalProperties ??= new Dictionary<string, BinaryData>();

            return new UnknownIntegrationRuntimeStatus(runtimeType == null ? default : new IntegrationRuntimeType(runtimeType), dataFactoryName, state, additionalProperties);
        }

        /// <summary> Initializes a new instance of <see cref="Models.IntegrationRuntimeOutboundNetworkDependenciesCategoryEndpoint"/>. </summary>
        /// <param name="category"> The category of outbound network dependency. </param>
        /// <param name="endpoints"> The endpoints for outbound network dependency. </param>
        /// <returns> A new <see cref="Models.IntegrationRuntimeOutboundNetworkDependenciesCategoryEndpoint"/> instance for mocking. </returns>
        public static IntegrationRuntimeOutboundNetworkDependenciesCategoryEndpoint IntegrationRuntimeOutboundNetworkDependenciesCategoryEndpoint(string category = null, IEnumerable<IntegrationRuntimeOutboundNetworkDependenciesEndpoint> endpoints = null)
        {
            endpoints ??= new List<IntegrationRuntimeOutboundNetworkDependenciesEndpoint>();

            return new IntegrationRuntimeOutboundNetworkDependenciesCategoryEndpoint(category, endpoints?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.IntegrationRuntimeOutboundNetworkDependenciesEndpoint"/>. </summary>
        /// <param name="domainName"> The domain name of endpoint. </param>
        /// <param name="endpointDetails"> The details of endpoint. </param>
        /// <returns> A new <see cref="Models.IntegrationRuntimeOutboundNetworkDependenciesEndpoint"/> instance for mocking. </returns>
        public static IntegrationRuntimeOutboundNetworkDependenciesEndpoint IntegrationRuntimeOutboundNetworkDependenciesEndpoint(string domainName = null, IEnumerable<IntegrationRuntimeOutboundNetworkDependenciesEndpointDetails> endpointDetails = null)
        {
            endpointDetails ??= new List<IntegrationRuntimeOutboundNetworkDependenciesEndpointDetails>();

            return new IntegrationRuntimeOutboundNetworkDependenciesEndpoint(domainName, endpointDetails?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.IntegrationRuntimeOutboundNetworkDependenciesEndpointDetails"/>. </summary>
        /// <param name="port"> The port of endpoint. </param>
        /// <returns> A new <see cref="Models.IntegrationRuntimeOutboundNetworkDependenciesEndpointDetails"/> instance for mocking. </returns>
        public static IntegrationRuntimeOutboundNetworkDependenciesEndpointDetails IntegrationRuntimeOutboundNetworkDependenciesEndpointDetails(int? port = null)
        {
            return new IntegrationRuntimeOutboundNetworkDependenciesEndpointDetails(port, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.IntegrationRuntimeConnectionInfo"/>. </summary>
        /// <param name="serviceToken"> The token generated in service. Callers use this token to authenticate to integration runtime. </param>
        /// <param name="identityCertThumbprint"> The integration runtime SSL certificate thumbprint. Click-Once application uses it to do server validation. </param>
        /// <param name="hostServiceUri"> The on-premises integration runtime host URL. </param>
        /// <param name="version"> The integration runtime version. </param>
        /// <param name="publicKey"> The public key for encrypting a credential when transferring the credential to the integration runtime. </param>
        /// <param name="isIdentityCertExprired"> Whether the identity certificate is expired. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <returns> A new <see cref="Models.IntegrationRuntimeConnectionInfo"/> instance for mocking. </returns>
        public static IntegrationRuntimeConnectionInfo IntegrationRuntimeConnectionInfo(string serviceToken = null, string identityCertThumbprint = null, Uri hostServiceUri = null, string version = null, string publicKey = null, bool? isIdentityCertExprired = null, IReadOnlyDictionary<string, BinaryData> additionalProperties = null)
        {
            additionalProperties ??= new Dictionary<string, BinaryData>();

            return new IntegrationRuntimeConnectionInfo(
                serviceToken,
                identityCertThumbprint,
                hostServiceUri,
                version,
                publicKey,
                isIdentityCertExprired,
                additionalProperties);
        }

        /// <summary> Initializes a new instance of <see cref="Models.IntegrationRuntimeAuthKeys"/>. </summary>
        /// <param name="authKey1"> The primary integration runtime authentication key. </param>
        /// <param name="authKey2"> The secondary integration runtime authentication key. </param>
        /// <returns> A new <see cref="Models.IntegrationRuntimeAuthKeys"/> instance for mocking. </returns>
        public static IntegrationRuntimeAuthKeys IntegrationRuntimeAuthKeys(string authKey1 = null, string authKey2 = null)
        {
            return new IntegrationRuntimeAuthKeys(authKey1, authKey2, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.IntegrationRuntimeMonitoringData"/>. </summary>
        /// <param name="name"> Integration runtime name. </param>
        /// <param name="nodes"> Integration runtime node monitoring data. </param>
        /// <returns> A new <see cref="Models.IntegrationRuntimeMonitoringData"/> instance for mocking. </returns>
        public static IntegrationRuntimeMonitoringData IntegrationRuntimeMonitoringData(string name = null, IEnumerable<IntegrationRuntimeNodeMonitoringData> nodes = null)
        {
            nodes ??= new List<IntegrationRuntimeNodeMonitoringData>();

            return new IntegrationRuntimeMonitoringData(name, nodes?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.IntegrationRuntimeNodeMonitoringData"/>. </summary>
        /// <param name="nodeName"> Name of the integration runtime node. </param>
        /// <param name="availableMemoryInMB"> Available memory (MB) on the integration runtime node. </param>
        /// <param name="cpuUtilization"> CPU percentage on the integration runtime node. </param>
        /// <param name="concurrentJobsLimit"> Maximum concurrent jobs on the integration runtime node. </param>
        /// <param name="concurrentJobsRunning"> The number of jobs currently running on the integration runtime node. </param>
        /// <param name="maxConcurrentJobs"> The maximum concurrent jobs in this integration runtime. </param>
        /// <param name="sentBytes"> Sent bytes on the integration runtime node. </param>
        /// <param name="receivedBytes"> Received bytes on the integration runtime node. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <returns> A new <see cref="Models.IntegrationRuntimeNodeMonitoringData"/> instance for mocking. </returns>
        public static IntegrationRuntimeNodeMonitoringData IntegrationRuntimeNodeMonitoringData(string nodeName = null, int? availableMemoryInMB = null, int? cpuUtilization = null, int? concurrentJobsLimit = null, int? concurrentJobsRunning = null, int? maxConcurrentJobs = null, float? sentBytes = null, float? receivedBytes = null, IReadOnlyDictionary<string, BinaryData> additionalProperties = null)
        {
            additionalProperties ??= new Dictionary<string, BinaryData>();

            return new IntegrationRuntimeNodeMonitoringData(
                nodeName,
                availableMemoryInMB,
                cpuUtilization,
                concurrentJobsLimit,
                concurrentJobsRunning,
                maxConcurrentJobs,
                sentBytes,
                receivedBytes,
                additionalProperties);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SsisObjectMetadataStatusResult"/>. </summary>
        /// <param name="status"> The status of the operation. </param>
        /// <param name="name"> The operation name. </param>
        /// <param name="properties"> The operation properties. </param>
        /// <param name="error"> The operation error message. </param>
        /// <returns> A new <see cref="Models.SsisObjectMetadataStatusResult"/> instance for mocking. </returns>
        public static SsisObjectMetadataStatusResult SsisObjectMetadataStatusResult(string status = null, string name = null, string properties = null, string error = null)
        {
            return new SsisObjectMetadataStatusResult(status, name, properties, error, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SsisObjectMetadata"/>. </summary>
        /// <param name="metadataType"> Type of metadata. </param>
        /// <param name="id"> Metadata id. </param>
        /// <param name="name"> Metadata name. </param>
        /// <param name="description"> Metadata description. </param>
        /// <returns> A new <see cref="Models.SsisObjectMetadata"/> instance for mocking. </returns>
        public static SsisObjectMetadata SsisObjectMetadata(string metadataType = null, long? id = null, string name = null, string description = null)
        {
            return new UnknownSsisObjectMetadata(metadataType == null ? default : new SsisObjectMetadataType(metadataType), id, name, description, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SelfHostedIntegrationRuntimeNode"/>. </summary>
        /// <param name="nodeName"> Name of the integration runtime node. </param>
        /// <param name="machineName"> Machine name of the integration runtime node. </param>
        /// <param name="hostServiceUri"> URI for the host machine of the integration runtime. </param>
        /// <param name="status"> Status of the integration runtime node. </param>
        /// <param name="capabilities"> The integration runtime capabilities dictionary. </param>
        /// <param name="versionStatus"> Status of the integration runtime node version. </param>
        /// <param name="version"> Version of the integration runtime node. </param>
        /// <param name="registerOn"> The time at which the integration runtime node was registered in ISO8601 format. </param>
        /// <param name="lastConnectOn"> The most recent time at which the integration runtime was connected in ISO8601 format. </param>
        /// <param name="expireOn"> The time at which the integration runtime will expire in ISO8601 format. </param>
        /// <param name="lastStartOn"> The time the node last started up. </param>
        /// <param name="lastStopOn"> The integration runtime node last stop time. </param>
        /// <param name="lastUpdateResult"> The result of the last integration runtime node update. </param>
        /// <param name="lastStartUpdateOn"> The last time for the integration runtime node update start. </param>
        /// <param name="lastEndUpdateOn"> The last time for the integration runtime node update end. </param>
        /// <param name="isActiveDispatcher"> Indicates whether this node is the active dispatcher for integration runtime requests. </param>
        /// <param name="concurrentJobsLimit"> Maximum concurrent jobs on the integration runtime node. </param>
        /// <param name="maxConcurrentJobs"> The maximum concurrent jobs in this integration runtime. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <returns> A new <see cref="Models.SelfHostedIntegrationRuntimeNode"/> instance for mocking. </returns>
        public static SelfHostedIntegrationRuntimeNode SelfHostedIntegrationRuntimeNode(string nodeName = null, string machineName = null, Uri hostServiceUri = null, SelfHostedIntegrationRuntimeNodeStatus? status = null, IReadOnlyDictionary<string, string> capabilities = null, string versionStatus = null, string version = null, DateTimeOffset? registerOn = null, DateTimeOffset? lastConnectOn = null, DateTimeOffset? expireOn = null, DateTimeOffset? lastStartOn = null, DateTimeOffset? lastStopOn = null, IntegrationRuntimeUpdateResult? lastUpdateResult = null, DateTimeOffset? lastStartUpdateOn = null, DateTimeOffset? lastEndUpdateOn = null, bool? isActiveDispatcher = null, int? concurrentJobsLimit = null, int? maxConcurrentJobs = null, IReadOnlyDictionary<string, BinaryData> additionalProperties = null)
        {
            capabilities ??= new Dictionary<string, string>();
            additionalProperties ??= new Dictionary<string, BinaryData>();

            return new SelfHostedIntegrationRuntimeNode(
                nodeName,
                machineName,
                hostServiceUri,
                status,
                capabilities,
                versionStatus,
                version,
                registerOn,
                lastConnectOn,
                expireOn,
                lastStartOn,
                lastStopOn,
                lastUpdateResult,
                lastStartUpdateOn,
                lastEndUpdateOn,
                isActiveDispatcher,
                concurrentJobsLimit,
                maxConcurrentJobs,
                additionalProperties);
        }

        /// <summary> Initializes a new instance of <see cref="Models.IntegrationRuntimeNodeIPAddress"/>. </summary>
        /// <param name="ipAddress"> The IP address of self-hosted integration runtime node. </param>
        /// <returns> A new <see cref="Models.IntegrationRuntimeNodeIPAddress"/> instance for mocking. </returns>
        public static IntegrationRuntimeNodeIPAddress IntegrationRuntimeNodeIPAddress(IPAddress ipAddress = null)
        {
            return new IntegrationRuntimeNodeIPAddress(ipAddress, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DataFactory.DataFactoryLinkedServiceData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties">
        /// Properties of linked service.
        /// Please note <see cref="DataFactoryLinkedServiceProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AmazonMwsLinkedService"/>, <see cref="AmazonRdsForOracleLinkedService"/>, <see cref="AmazonRdsForSqlServerLinkedService"/>, <see cref="AmazonRedshiftLinkedService"/>, <see cref="AmazonS3LinkedService"/>, <see cref="AmazonS3CompatibleLinkedService"/>, <see cref="AppFiguresLinkedService"/>, <see cref="AsanaLinkedService"/>, <see cref="AzureBatchLinkedService"/>, <see cref="AzureBlobFSLinkedService"/>, <see cref="AzureBlobStorageLinkedService"/>, <see cref="AzureDatabricksLinkedService"/>, <see cref="AzureDatabricksDeltaLakeLinkedService"/>, <see cref="AzureDataExplorerLinkedService"/>, <see cref="AzureDataLakeAnalyticsLinkedService"/>, <see cref="AzureDataLakeStoreLinkedService"/>, <see cref="AzureFileStorageLinkedService"/>, <see cref="AzureFunctionLinkedService"/>, <see cref="AzureKeyVaultLinkedService"/>, <see cref="AzureMariaDBLinkedService"/>, <see cref="AzureMLLinkedService"/>, <see cref="AzureMLServiceLinkedService"/>, <see cref="AzureMySqlLinkedService"/>, <see cref="AzurePostgreSqlLinkedService"/>, <see cref="AzureSearchLinkedService"/>, <see cref="AzureSqlDatabaseLinkedService"/>, <see cref="AzureSqlDWLinkedService"/>, <see cref="AzureSqlMILinkedService"/>, <see cref="AzureStorageLinkedService"/>, <see cref="AzureSynapseArtifactsLinkedService"/>, <see cref="AzureTableStorageLinkedService"/>, <see cref="CassandraLinkedService"/>, <see cref="CommonDataServiceForAppsLinkedService"/>, <see cref="ConcurLinkedService"/>, <see cref="CosmosDBLinkedService"/>, <see cref="CosmosDBMongoDBApiLinkedService"/>, <see cref="CouchbaseLinkedService"/>, <see cref="CustomDataSourceLinkedService"/>, <see cref="DataworldLinkedService"/>, <see cref="Db2LinkedService"/>, <see cref="DrillLinkedService"/>, <see cref="DynamicsLinkedService"/>, <see cref="DynamicsAXLinkedService"/>, <see cref="DynamicsCrmLinkedService"/>, <see cref="EloquaLinkedService"/>, <see cref="FileServerLinkedService"/>, <see cref="FtpServerLinkedService"/>, <see cref="GoogleAdWordsLinkedService"/>, <see cref="GoogleBigQueryLinkedService"/>, <see cref="GoogleBigQueryV2LinkedService"/>, <see cref="GoogleCloudStorageLinkedService"/>, <see cref="GoogleSheetsLinkedService"/>, <see cref="GreenplumLinkedService"/>, <see cref="HBaseLinkedService"/>, <see cref="HdfsLinkedService"/>, <see cref="HDInsightLinkedService"/>, <see cref="HDInsightOnDemandLinkedService"/>, <see cref="HiveLinkedService"/>, <see cref="HttpLinkedService"/>, <see cref="HubspotLinkedService"/>, <see cref="ImpalaLinkedService"/>, <see cref="InformixLinkedService"/>, <see cref="JiraLinkedService"/>, <see cref="LakeHouseLinkedService"/>, <see cref="MagentoLinkedService"/>, <see cref="MariaDBLinkedService"/>, <see cref="MarketoLinkedService"/>, <see cref="MicrosoftAccessLinkedService"/>, <see cref="MongoDBLinkedService"/>, <see cref="MongoDBAtlasLinkedService"/>, <see cref="MongoDBV2LinkedService"/>, <see cref="MySqlLinkedService"/>, <see cref="NetezzaLinkedService"/>, <see cref="ODataLinkedService"/>, <see cref="OdbcLinkedService"/>, <see cref="Office365LinkedService"/>, <see cref="OracleLinkedService"/>, <see cref="OracleCloudStorageLinkedService"/>, <see cref="OracleServiceCloudLinkedService"/>, <see cref="PaypalLinkedService"/>, <see cref="PhoenixLinkedService"/>, <see cref="PostgreSqlLinkedService"/>, <see cref="PostgreSqlV2LinkedService"/>, <see cref="PrestoLinkedService"/>, <see cref="QuickbaseLinkedService"/>, <see cref="QuickBooksLinkedService"/>, <see cref="ResponsysLinkedService"/>, <see cref="RestServiceLinkedService"/>, <see cref="SalesforceLinkedService"/>, <see cref="SalesforceMarketingCloudLinkedService"/>, <see cref="SalesforceServiceCloudLinkedService"/>, <see cref="SalesforceServiceCloudV2LinkedService"/>, <see cref="SalesforceV2LinkedService"/>, <see cref="SapBWLinkedService"/>, <see cref="SapCloudForCustomerLinkedService"/>, <see cref="SapEccLinkedService"/>, <see cref="SapHanaLinkedService"/>, <see cref="SapOdpLinkedService"/>, <see cref="SapOpenHubLinkedService"/>, <see cref="SapTableLinkedService"/>, <see cref="ServiceNowLinkedService"/>, <see cref="ServiceNowV2LinkedService"/>, <see cref="SftpServerLinkedService"/>, <see cref="SharePointOnlineListLinkedService"/>, <see cref="ShopifyLinkedService"/>, <see cref="SmartsheetLinkedService"/>, <see cref="SnowflakeLinkedService"/>, <see cref="SnowflakeV2LinkedService"/>, <see cref="SparkLinkedService"/>, <see cref="SqlServerLinkedService"/>, <see cref="SquareLinkedService"/>, <see cref="SybaseLinkedService"/>, <see cref="TeamDeskLinkedService"/>, <see cref="TeradataLinkedService"/>, <see cref="TwilioLinkedService"/>, <see cref="VerticaLinkedService"/>, <see cref="WarehouseLinkedService"/>, <see cref="WebLinkedService"/>, <see cref="XeroLinkedService"/>, <see cref="ZendeskLinkedService"/> and <see cref="ZohoLinkedService"/>.
        /// </param>
        /// <param name="eTag"> Etag identifies change in the resource. </param>
        /// <returns> A new <see cref="DataFactory.DataFactoryLinkedServiceData"/> instance for mocking. </returns>
        public static DataFactoryLinkedServiceData DataFactoryLinkedServiceData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, DataFactoryLinkedServiceProperties properties = null, ETag? eTag = null)
        {
            return new DataFactoryLinkedServiceData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                eTag,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DataFactory.DataFactoryDatasetData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties">
        /// Dataset properties.
        /// Please note <see cref="DataFactoryDatasetProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AmazonMwsObjectDataset"/>, <see cref="AmazonRdsForOracleTableDataset"/>, <see cref="AmazonRdsForSqlServerTableDataset"/>, <see cref="AmazonRedshiftTableDataset"/>, <see cref="AmazonS3Dataset"/>, <see cref="AvroDataset"/>, <see cref="AzureBlobDataset"/>, <see cref="AzureBlobFSDataset"/>, <see cref="AzureDatabricksDeltaLakeDataset"/>, <see cref="AzureDataExplorerTableDataset"/>, <see cref="AzureDataLakeStoreDataset"/>, <see cref="AzureMariaDBTableDataset"/>, <see cref="AzureMySqlTableDataset"/>, <see cref="AzurePostgreSqlTableDataset"/>, <see cref="AzureSearchIndexDataset"/>, <see cref="AzureSqlDWTableDataset"/>, <see cref="AzureSqlMITableDataset"/>, <see cref="AzureSqlTableDataset"/>, <see cref="AzureTableDataset"/>, <see cref="BinaryDataset"/>, <see cref="CassandraTableDataset"/>, <see cref="CommonDataServiceForAppsEntityDataset"/>, <see cref="ConcurObjectDataset"/>, <see cref="CosmosDBMongoDBApiCollectionDataset"/>, <see cref="CosmosDBSqlApiCollectionDataset"/>, <see cref="CouchbaseTableDataset"/>, <see cref="CustomDataset"/>, <see cref="Db2TableDataset"/>, <see cref="DelimitedTextDataset"/>, <see cref="DocumentDBCollectionDataset"/>, <see cref="DrillTableDataset"/>, <see cref="DynamicsAXResourceDataset"/>, <see cref="DynamicsCrmEntityDataset"/>, <see cref="DynamicsEntityDataset"/>, <see cref="EloquaObjectDataset"/>, <see cref="ExcelDataset"/>, <see cref="FileShareDataset"/>, <see cref="GoogleAdWordsObjectDataset"/>, <see cref="GoogleBigQueryObjectDataset"/>, <see cref="GoogleBigQueryV2ObjectDataset"/>, <see cref="GreenplumTableDataset"/>, <see cref="HBaseObjectDataset"/>, <see cref="HiveObjectDataset"/>, <see cref="DataFactoryHttpDataset"/>, <see cref="HubspotObjectDataset"/>, <see cref="IcebergDataset"/>, <see cref="ImpalaObjectDataset"/>, <see cref="InformixTableDataset"/>, <see cref="JiraObjectDataset"/>, <see cref="JsonDataset"/>, <see cref="LakeHouseTableDataset"/>, <see cref="MagentoObjectDataset"/>, <see cref="MariaDBTableDataset"/>, <see cref="MarketoObjectDataset"/>, <see cref="MicrosoftAccessTableDataset"/>, <see cref="MongoDBAtlasCollectionDataset"/>, <see cref="MongoDBCollectionDataset"/>, <see cref="MongoDBV2CollectionDataset"/>, <see cref="MySqlTableDataset"/>, <see cref="NetezzaTableDataset"/>, <see cref="ODataResourceDataset"/>, <see cref="OdbcTableDataset"/>, <see cref="Office365Dataset"/>, <see cref="OracleServiceCloudObjectDataset"/>, <see cref="OracleTableDataset"/>, <see cref="OrcDataset"/>, <see cref="ParquetDataset"/>, <see cref="PaypalObjectDataset"/>, <see cref="PhoenixObjectDataset"/>, <see cref="PostgreSqlTableDataset"/>, <see cref="PostgreSqlV2TableDataset"/>, <see cref="PrestoObjectDataset"/>, <see cref="QuickBooksObjectDataset"/>, <see cref="RelationalTableDataset"/>, <see cref="ResponsysObjectDataset"/>, <see cref="RestResourceDataset"/>, <see cref="SalesforceMarketingCloudObjectDataset"/>, <see cref="SalesforceObjectDataset"/>, <see cref="SalesforceServiceCloudObjectDataset"/>, <see cref="SalesforceServiceCloudV2ObjectDataset"/>, <see cref="SalesforceV2ObjectDataset"/>, <see cref="SapBWCubeDataset"/>, <see cref="SapCloudForCustomerResourceDataset"/>, <see cref="SapEccResourceDataset"/>, <see cref="SapHanaTableDataset"/>, <see cref="SapOdpResourceDataset"/>, <see cref="SapOpenHubTableDataset"/>, <see cref="SapTableResourceDataset"/>, <see cref="ServiceNowObjectDataset"/>, <see cref="ServiceNowV2ObjectDataset"/>, <see cref="SharePointOnlineListResourceDataset"/>, <see cref="ShopifyObjectDataset"/>, <see cref="SnowflakeDataset"/>, <see cref="SnowflakeV2Dataset"/>, <see cref="SparkObjectDataset"/>, <see cref="SqlServerTableDataset"/>, <see cref="SquareObjectDataset"/>, <see cref="SybaseTableDataset"/>, <see cref="TeradataTableDataset"/>, <see cref="VerticaTableDataset"/>, <see cref="WarehouseTableDataset"/>, <see cref="WebTableDataset"/>, <see cref="XeroObjectDataset"/>, <see cref="XmlDataset"/> and <see cref="ZohoObjectDataset"/>.
        /// </param>
        /// <param name="eTag"> Etag identifies change in the resource. </param>
        /// <returns> A new <see cref="DataFactory.DataFactoryDatasetData"/> instance for mocking. </returns>
        public static DataFactoryDatasetData DataFactoryDatasetData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, DataFactoryDatasetProperties properties = null, ETag? eTag = null)
        {
            return new DataFactoryDatasetData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                eTag,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DataFactory.DataFactoryPipelineData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="description"> The description of the pipeline. </param>
        /// <param name="activities">
        /// List of activities in pipeline.
        /// Please note <see cref="PipelineActivity"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AppendVariableActivity"/>, <see cref="AzureDataExplorerCommandActivity"/>, <see cref="AzureFunctionActivity"/>, <see cref="AzureMLBatchExecutionActivity"/>, <see cref="AzureMLExecutePipelineActivity"/>, <see cref="AzureMLUpdateResourceActivity"/>, <see cref="ControlActivity"/>, <see cref="CopyActivity"/>, <see cref="CustomActivity"/>, <see cref="DatabricksNotebookActivity"/>, <see cref="DatabricksSparkJarActivity"/>, <see cref="DatabricksSparkPythonActivity"/>, <see cref="DataLakeAnalyticsUsqlActivity"/>, <see cref="DeleteActivity"/>, <see cref="ExecuteDataFlowActivity"/>, <see cref="ExecutePipelineActivity"/>, <see cref="ExecuteSsisPackageActivity"/>, <see cref="ExecuteWranglingDataflowActivity"/>, <see cref="ExecutionActivity"/>, <see cref="FailActivity"/>, <see cref="FilterActivity"/>, <see cref="ForEachActivity"/>, <see cref="GetDatasetMetadataActivity"/>, <see cref="HDInsightHiveActivity"/>, <see cref="HDInsightMapReduceActivity"/>, <see cref="HDInsightPigActivity"/>, <see cref="HDInsightSparkActivity"/>, <see cref="HDInsightStreamingActivity"/>, <see cref="IfConditionActivity"/>, <see cref="LookupActivity"/>, <see cref="DataFactoryScriptActivity"/>, <see cref="SetVariableActivity"/>, <see cref="SynapseSparkJobDefinitionActivity"/>, <see cref="SqlServerStoredProcedureActivity"/>, <see cref="SwitchActivity"/>, <see cref="SynapseNotebookActivity"/>, <see cref="UntilActivity"/>, <see cref="ValidationActivity"/>, <see cref="WaitActivity"/>, <see cref="WebActivity"/> and <see cref="WebHookActivity"/>.
        /// </param>
        /// <param name="parameters"> List of parameters for pipeline. </param>
        /// <param name="variables"> List of variables for pipeline. </param>
        /// <param name="concurrency"> The max number of concurrent runs for the pipeline. </param>
        /// <param name="annotations"> List of tags that can be used for describing the Pipeline. </param>
        /// <param name="runDimensions"> Dimensions emitted by Pipeline. </param>
        /// <param name="folderName"> The folder that this Pipeline is in. If not specified, Pipeline will appear at the root level. </param>
        /// <param name="elapsedTimeMetricDuration"> Pipeline Policy. </param>
        /// <param name="eTag"> Etag identifies change in the resource. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <returns> A new <see cref="DataFactory.DataFactoryPipelineData"/> instance for mocking. </returns>
        public static DataFactoryPipelineData DataFactoryPipelineData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string description = null, IEnumerable<PipelineActivity> activities = null, IDictionary<string, EntityParameterSpecification> parameters = null, IDictionary<string, PipelineVariableSpecification> variables = null, int? concurrency = null, IEnumerable<BinaryData> annotations = null, IDictionary<string, BinaryData> runDimensions = null, string folderName = null, BinaryData elapsedTimeMetricDuration = null, ETag? eTag = null, IDictionary<string, BinaryData> additionalProperties = null)
        {
            activities ??= new List<PipelineActivity>();
            parameters ??= new Dictionary<string, EntityParameterSpecification>();
            variables ??= new Dictionary<string, PipelineVariableSpecification>();
            annotations ??= new List<BinaryData>();
            runDimensions ??= new Dictionary<string, BinaryData>();
            additionalProperties ??= new Dictionary<string, BinaryData>();

            return new DataFactoryPipelineData(
                id,
                name,
                resourceType,
                systemData,
                description,
                activities?.ToList(),
                parameters,
                variables,
                concurrency,
                annotations?.ToList(),
                runDimensions,
                folderName != null ? new PipelineFolder(folderName, serializedAdditionalRawData: null) : null,
                elapsedTimeMetricDuration != null ? new DataFactoryPipelinePolicy(new PipelineElapsedTimeMetricPolicy(elapsedTimeMetricDuration, serializedAdditionalRawData: null), serializedAdditionalRawData: null) : null,
                eTag,
                additionalProperties);
        }

        /// <summary> Initializes a new instance of <see cref="Models.PipelineCreateRunResult"/>. </summary>
        /// <param name="runId"> Identifier of a run. </param>
        /// <returns> A new <see cref="Models.PipelineCreateRunResult"/> instance for mocking. </returns>
        public static PipelineCreateRunResult PipelineCreateRunResult(Guid runId = default)
        {
            return new PipelineCreateRunResult(runId, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RunFilterContent"/>. </summary>
        /// <param name="continuationToken"> The continuation token for getting the next page of results. Null for first page. </param>
        /// <param name="lastUpdatedAfter"> The time at or after which the run event was updated in 'ISO 8601' format. </param>
        /// <param name="lastUpdatedBefore"> The time at or before which the run event was updated in 'ISO 8601' format. </param>
        /// <param name="filters"> List of filters. </param>
        /// <param name="orderBy"> List of OrderBy option. </param>
        /// <returns> A new <see cref="Models.RunFilterContent"/> instance for mocking. </returns>
        public static RunFilterContent RunFilterContent(string continuationToken = null, DateTimeOffset lastUpdatedAfter = default, DateTimeOffset lastUpdatedBefore = default, IEnumerable<RunQueryFilter> filters = null, IEnumerable<RunQueryOrderBy> orderBy = null)
        {
            filters ??= new List<RunQueryFilter>();
            orderBy ??= new List<RunQueryOrderBy>();

            return new RunFilterContent(
                continuationToken,
                lastUpdatedAfter,
                lastUpdatedBefore,
                filters?.ToList(),
                orderBy?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataFactoryPipelineRunInfo"/>. </summary>
        /// <param name="runId"> Identifier of a run. </param>
        /// <param name="runGroupId"> Identifier that correlates all the recovery runs of a pipeline run. </param>
        /// <param name="isLatest"> Indicates if the recovered pipeline run is the latest in its group. </param>
        /// <param name="pipelineName"> The pipeline name. </param>
        /// <param name="parameters"> The full or partial list of parameter name, value pair used in the pipeline run. </param>
        /// <param name="runDimensions"> Run dimensions emitted by Pipeline run. </param>
        /// <param name="invokedBy"> Entity that started the pipeline run. </param>
        /// <param name="lastUpdatedOn"> The last updated timestamp for the pipeline run event in ISO8601 format. </param>
        /// <param name="runStartOn"> The start time of a pipeline run in ISO8601 format. </param>
        /// <param name="runEndOn"> The end time of a pipeline run in ISO8601 format. </param>
        /// <param name="durationInMs"> The duration of a pipeline run. </param>
        /// <param name="status"> The status of a pipeline run. Possible values: Queued, InProgress, Succeeded, Failed, Canceling, Cancelled. </param>
        /// <param name="message"> The message from a pipeline run. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <returns> A new <see cref="Models.DataFactoryPipelineRunInfo"/> instance for mocking. </returns>
        public static DataFactoryPipelineRunInfo DataFactoryPipelineRunInfo(Guid? runId = null, string runGroupId = null, bool? isLatest = null, string pipelineName = null, IReadOnlyDictionary<string, string> parameters = null, IReadOnlyDictionary<string, string> runDimensions = null, DataFactoryPipelineRunEntityInfo invokedBy = null, DateTimeOffset? lastUpdatedOn = null, DateTimeOffset? runStartOn = null, DateTimeOffset? runEndOn = null, int? durationInMs = null, string status = null, string message = null, IReadOnlyDictionary<string, BinaryData> additionalProperties = null)
        {
            parameters ??= new Dictionary<string, string>();
            runDimensions ??= new Dictionary<string, string>();
            additionalProperties ??= new Dictionary<string, BinaryData>();

            return new DataFactoryPipelineRunInfo(
                runId,
                runGroupId,
                isLatest,
                pipelineName,
                parameters,
                runDimensions,
                invokedBy,
                lastUpdatedOn,
                runStartOn,
                runEndOn,
                durationInMs,
                status,
                message,
                additionalProperties);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataFactoryPipelineRunEntityInfo"/>. </summary>
        /// <param name="name"> Name of the entity that started the pipeline run. </param>
        /// <param name="id"> The ID of the entity that started the run. </param>
        /// <param name="invokedByType"> The type of the entity that started the run. </param>
        /// <param name="pipelineName"> The name of the pipeline that triggered the run, if any. </param>
        /// <param name="pipelineRunId"> The run id of the pipeline that triggered the run, if any. </param>
        /// <returns> A new <see cref="Models.DataFactoryPipelineRunEntityInfo"/> instance for mocking. </returns>
        public static DataFactoryPipelineRunEntityInfo DataFactoryPipelineRunEntityInfo(string name = null, string id = null, string invokedByType = null, string pipelineName = null, Guid? pipelineRunId = null)
        {
            return new DataFactoryPipelineRunEntityInfo(
                name,
                id,
                invokedByType,
                pipelineName,
                pipelineRunId,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.PipelineActivityRunInformation"/>. </summary>
        /// <param name="pipelineName"> The name of the pipeline. </param>
        /// <param name="pipelineRunId"> The id of the pipeline run. </param>
        /// <param name="activityName"> The name of the activity. </param>
        /// <param name="activityType"> The type of the activity. </param>
        /// <param name="activityRunId"> The id of the activity run. </param>
        /// <param name="linkedServiceName"> The name of the compute linked service. </param>
        /// <param name="status"> The status of the activity run. </param>
        /// <param name="startOn"> The start time of the activity run in 'ISO 8601' format. </param>
        /// <param name="endOn"> The end time of the activity run in 'ISO 8601' format. </param>
        /// <param name="durationInMs"> The duration of the activity run. </param>
        /// <param name="input"> The input for the activity. </param>
        /// <param name="output"> The output for the activity. </param>
        /// <param name="error"> The error if any from the activity run. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <returns> A new <see cref="Models.PipelineActivityRunInformation"/> instance for mocking. </returns>
        public static PipelineActivityRunInformation PipelineActivityRunInformation(string pipelineName = null, Guid? pipelineRunId = null, string activityName = null, string activityType = null, Guid? activityRunId = null, string linkedServiceName = null, string status = null, DateTimeOffset? startOn = null, DateTimeOffset? endOn = null, int? durationInMs = null, BinaryData input = null, BinaryData output = null, BinaryData error = null, IReadOnlyDictionary<string, BinaryData> additionalProperties = null)
        {
            additionalProperties ??= new Dictionary<string, BinaryData>();

            return new PipelineActivityRunInformation(
                pipelineName,
                pipelineRunId,
                activityName,
                activityType,
                activityRunId,
                linkedServiceName,
                status,
                startOn,
                endOn,
                durationInMs,
                input,
                output,
                error,
                additionalProperties);
        }

        /// <summary> Initializes a new instance of <see cref="DataFactory.DataFactoryTriggerData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties">
        /// Properties of the trigger.
        /// Please note <see cref="Models.DataFactoryTriggerProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.DataFactoryBlobEventsTrigger"/>, <see cref="Models.DataFactoryBlobTrigger"/>, <see cref="Models.ChainingTrigger"/>, <see cref="Models.CustomEventsTrigger"/>, <see cref="Models.MultiplePipelineTrigger"/>, <see cref="Models.RerunTumblingWindowTrigger"/>, <see cref="Models.DataFactoryScheduleTrigger"/> and <see cref="Models.TumblingWindowTrigger"/>.
        /// </param>
        /// <param name="eTag"> Etag identifies change in the resource. </param>
        /// <returns> A new <see cref="DataFactory.DataFactoryTriggerData"/> instance for mocking. </returns>
        public static DataFactoryTriggerData DataFactoryTriggerData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, DataFactoryTriggerProperties properties = null, ETag? eTag = null)
        {
            return new DataFactoryTriggerData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                eTag,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataFactoryTriggerProperties"/>. </summary>
        /// <param name="triggerType"> Trigger type. </param>
        /// <param name="description"> Trigger description. </param>
        /// <param name="runtimeState"> Indicates if trigger is running or not. Updated when Start/Stop APIs are called on the Trigger. </param>
        /// <param name="annotations"> List of tags that can be used for describing the trigger. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <returns> A new <see cref="Models.DataFactoryTriggerProperties"/> instance for mocking. </returns>
        public static DataFactoryTriggerProperties DataFactoryTriggerProperties(string triggerType = null, string description = null, DataFactoryTriggerRuntimeState? runtimeState = null, IEnumerable<BinaryData> annotations = null, IDictionary<string, BinaryData> additionalProperties = null)
        {
            annotations ??= new List<BinaryData>();
            additionalProperties ??= new Dictionary<string, BinaryData>();

            return new UnknownTrigger(triggerType, description, runtimeState, annotations?.ToList(), additionalProperties);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataFactoryTriggerSubscriptionOperationResult"/>. </summary>
        /// <param name="triggerName"> Trigger name. </param>
        /// <param name="status"> Event Subscription Status. </param>
        /// <returns> A new <see cref="Models.DataFactoryTriggerSubscriptionOperationResult"/> instance for mocking. </returns>
        public static DataFactoryTriggerSubscriptionOperationResult DataFactoryTriggerSubscriptionOperationResult(string triggerName = null, EventSubscriptionStatus? status = null)
        {
            return new DataFactoryTriggerSubscriptionOperationResult(triggerName, status, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataFactoryTriggerRun"/>. </summary>
        /// <param name="triggerRunId"> Trigger run id. </param>
        /// <param name="triggerName"> Trigger name. </param>
        /// <param name="triggerType"> Trigger type. </param>
        /// <param name="triggerRunTimestamp"> Trigger run start time. </param>
        /// <param name="status"> Trigger run status. </param>
        /// <param name="message"> Trigger error message. </param>
        /// <param name="properties"> List of property name and value related to trigger run. Name, value pair depends on type of trigger. </param>
        /// <param name="triggeredPipelines"> List of pipeline name and run Id triggered by the trigger run. </param>
        /// <param name="runDimension"> Run dimension for which trigger was fired. </param>
        /// <param name="dependencyStatus"> Status of the upstream pipelines. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <returns> A new <see cref="Models.DataFactoryTriggerRun"/> instance for mocking. </returns>
        public static DataFactoryTriggerRun DataFactoryTriggerRun(string triggerRunId = null, string triggerName = null, string triggerType = null, DateTimeOffset? triggerRunTimestamp = null, DataFactoryTriggerRunStatus? status = null, string message = null, IReadOnlyDictionary<string, string> properties = null, IReadOnlyDictionary<string, string> triggeredPipelines = null, IReadOnlyDictionary<string, string> runDimension = null, IReadOnlyDictionary<string, BinaryData> dependencyStatus = null, IReadOnlyDictionary<string, BinaryData> additionalProperties = null)
        {
            properties ??= new Dictionary<string, string>();
            triggeredPipelines ??= new Dictionary<string, string>();
            runDimension ??= new Dictionary<string, string>();
            dependencyStatus ??= new Dictionary<string, BinaryData>();
            additionalProperties ??= new Dictionary<string, BinaryData>();

            return new DataFactoryTriggerRun(
                triggerRunId,
                triggerName,
                triggerType,
                triggerRunTimestamp,
                status,
                message,
                properties,
                triggeredPipelines,
                runDimension,
                dependencyStatus,
                additionalProperties);
        }

        /// <summary> Initializes a new instance of <see cref="DataFactory.DataFactoryDataFlowData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties">
        /// Data flow properties.
        /// Please note <see cref="DataFactoryDataFlowProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="DataFactoryFlowletProperties"/>, <see cref="DataFactoryMappingDataFlowProperties"/> and <see cref="DataFactoryWranglingDataFlowProperties"/>.
        /// </param>
        /// <param name="eTag"> Etag identifies change in the resource. </param>
        /// <returns> A new <see cref="DataFactory.DataFactoryDataFlowData"/> instance for mocking. </returns>
        public static DataFactoryDataFlowData DataFactoryDataFlowData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, DataFactoryDataFlowProperties properties = null, ETag? eTag = null)
        {
            return new DataFactoryDataFlowData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                eTag,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataFactoryIntegrationRuntimeDebugInfo"/>. </summary>
        /// <param name="name"> The resource name. </param>
        /// <param name="properties">
        /// Integration runtime properties.
        /// Please note <see cref="DataFactoryIntegrationRuntimeProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.ManagedIntegrationRuntime"/> and <see cref="SelfHostedIntegrationRuntime"/>.
        /// </param>
        /// <returns> A new <see cref="Models.DataFactoryIntegrationRuntimeDebugInfo"/> instance for mocking. </returns>
        public static DataFactoryIntegrationRuntimeDebugInfo DataFactoryIntegrationRuntimeDebugInfo(string name = null, DataFactoryIntegrationRuntimeProperties properties = null)
        {
            return new DataFactoryIntegrationRuntimeDebugInfo(name, serializedAdditionalRawData: null, properties);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataFactoryDataFlowCreateDebugSessionResult"/>. </summary>
        /// <param name="status"> The state of the debug session. </param>
        /// <param name="sessionId"> The ID of data flow debug session. </param>
        /// <returns> A new <see cref="Models.DataFactoryDataFlowCreateDebugSessionResult"/> instance for mocking. </returns>
        public static DataFactoryDataFlowCreateDebugSessionResult DataFactoryDataFlowCreateDebugSessionResult(string status = null, Guid? sessionId = null)
        {
            return new DataFactoryDataFlowCreateDebugSessionResult(status, sessionId, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataFlowDebugSessionInfo"/>. </summary>
        /// <param name="dataFlowName"> The name of the data flow. </param>
        /// <param name="computeType"> Compute type of the cluster. </param>
        /// <param name="coreCount"> Core count of the cluster. </param>
        /// <param name="nodeCount"> Node count of the cluster. (deprecated property). </param>
        /// <param name="integrationRuntimeName"> Attached integration runtime name of data flow debug session. </param>
        /// <param name="sessionId"> The ID of data flow debug session. </param>
        /// <param name="startOn"> Start time of data flow debug session. </param>
        /// <param name="timeToLiveInMinutes"> Compute type of the cluster. </param>
        /// <param name="lastActivityOn"> Last activity time of data flow debug session. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <returns> A new <see cref="Models.DataFlowDebugSessionInfo"/> instance for mocking. </returns>
        public static DataFlowDebugSessionInfo DataFlowDebugSessionInfo(string dataFlowName = null, string computeType = null, int? coreCount = null, int? nodeCount = null, string integrationRuntimeName = null, Guid? sessionId = null, DateTimeOffset? startOn = null, int? timeToLiveInMinutes = null, DateTimeOffset? lastActivityOn = null, IReadOnlyDictionary<string, BinaryData> additionalProperties = null)
        {
            additionalProperties ??= new Dictionary<string, BinaryData>();

            return new DataFlowDebugSessionInfo(
                dataFlowName,
                computeType,
                coreCount,
                nodeCount,
                integrationRuntimeName,
                sessionId,
                startOn,
                timeToLiveInMinutes,
                lastActivityOn,
                additionalProperties);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataFactoryDataFlowDebugInfo"/>. </summary>
        /// <param name="name"> The resource name. </param>
        /// <param name="properties">
        /// Data flow properties.
        /// Please note <see cref="DataFactoryDataFlowProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="DataFactoryFlowletProperties"/>, <see cref="DataFactoryMappingDataFlowProperties"/> and <see cref="DataFactoryWranglingDataFlowProperties"/>.
        /// </param>
        /// <returns> A new <see cref="Models.DataFactoryDataFlowDebugInfo"/> instance for mocking. </returns>
        public static DataFactoryDataFlowDebugInfo DataFactoryDataFlowDebugInfo(string name = null, DataFactoryDataFlowProperties properties = null)
        {
            return new DataFactoryDataFlowDebugInfo(name, serializedAdditionalRawData: null, properties);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataFactoryDatasetDebugInfo"/>. </summary>
        /// <param name="name"> The resource name. </param>
        /// <param name="properties">
        /// Dataset properties.
        /// Please note <see cref="DataFactoryDatasetProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AmazonMwsObjectDataset"/>, <see cref="AmazonRdsForOracleTableDataset"/>, <see cref="AmazonRdsForSqlServerTableDataset"/>, <see cref="AmazonRedshiftTableDataset"/>, <see cref="AmazonS3Dataset"/>, <see cref="AvroDataset"/>, <see cref="AzureBlobDataset"/>, <see cref="AzureBlobFSDataset"/>, <see cref="AzureDatabricksDeltaLakeDataset"/>, <see cref="AzureDataExplorerTableDataset"/>, <see cref="AzureDataLakeStoreDataset"/>, <see cref="AzureMariaDBTableDataset"/>, <see cref="AzureMySqlTableDataset"/>, <see cref="AzurePostgreSqlTableDataset"/>, <see cref="AzureSearchIndexDataset"/>, <see cref="AzureSqlDWTableDataset"/>, <see cref="AzureSqlMITableDataset"/>, <see cref="AzureSqlTableDataset"/>, <see cref="AzureTableDataset"/>, <see cref="BinaryDataset"/>, <see cref="CassandraTableDataset"/>, <see cref="CommonDataServiceForAppsEntityDataset"/>, <see cref="ConcurObjectDataset"/>, <see cref="CosmosDBMongoDBApiCollectionDataset"/>, <see cref="CosmosDBSqlApiCollectionDataset"/>, <see cref="CouchbaseTableDataset"/>, <see cref="CustomDataset"/>, <see cref="Db2TableDataset"/>, <see cref="DelimitedTextDataset"/>, <see cref="DocumentDBCollectionDataset"/>, <see cref="DrillTableDataset"/>, <see cref="DynamicsAXResourceDataset"/>, <see cref="DynamicsCrmEntityDataset"/>, <see cref="DynamicsEntityDataset"/>, <see cref="EloquaObjectDataset"/>, <see cref="ExcelDataset"/>, <see cref="FileShareDataset"/>, <see cref="GoogleAdWordsObjectDataset"/>, <see cref="GoogleBigQueryObjectDataset"/>, <see cref="GoogleBigQueryV2ObjectDataset"/>, <see cref="GreenplumTableDataset"/>, <see cref="HBaseObjectDataset"/>, <see cref="HiveObjectDataset"/>, <see cref="DataFactoryHttpDataset"/>, <see cref="HubspotObjectDataset"/>, <see cref="IcebergDataset"/>, <see cref="ImpalaObjectDataset"/>, <see cref="InformixTableDataset"/>, <see cref="JiraObjectDataset"/>, <see cref="JsonDataset"/>, <see cref="LakeHouseTableDataset"/>, <see cref="MagentoObjectDataset"/>, <see cref="MariaDBTableDataset"/>, <see cref="MarketoObjectDataset"/>, <see cref="MicrosoftAccessTableDataset"/>, <see cref="MongoDBAtlasCollectionDataset"/>, <see cref="MongoDBCollectionDataset"/>, <see cref="MongoDBV2CollectionDataset"/>, <see cref="MySqlTableDataset"/>, <see cref="NetezzaTableDataset"/>, <see cref="ODataResourceDataset"/>, <see cref="OdbcTableDataset"/>, <see cref="Office365Dataset"/>, <see cref="OracleServiceCloudObjectDataset"/>, <see cref="OracleTableDataset"/>, <see cref="OrcDataset"/>, <see cref="ParquetDataset"/>, <see cref="PaypalObjectDataset"/>, <see cref="PhoenixObjectDataset"/>, <see cref="PostgreSqlTableDataset"/>, <see cref="PostgreSqlV2TableDataset"/>, <see cref="PrestoObjectDataset"/>, <see cref="QuickBooksObjectDataset"/>, <see cref="RelationalTableDataset"/>, <see cref="ResponsysObjectDataset"/>, <see cref="RestResourceDataset"/>, <see cref="SalesforceMarketingCloudObjectDataset"/>, <see cref="SalesforceObjectDataset"/>, <see cref="SalesforceServiceCloudObjectDataset"/>, <see cref="SalesforceServiceCloudV2ObjectDataset"/>, <see cref="SalesforceV2ObjectDataset"/>, <see cref="SapBWCubeDataset"/>, <see cref="SapCloudForCustomerResourceDataset"/>, <see cref="SapEccResourceDataset"/>, <see cref="SapHanaTableDataset"/>, <see cref="SapOdpResourceDataset"/>, <see cref="SapOpenHubTableDataset"/>, <see cref="SapTableResourceDataset"/>, <see cref="ServiceNowObjectDataset"/>, <see cref="ServiceNowV2ObjectDataset"/>, <see cref="SharePointOnlineListResourceDataset"/>, <see cref="ShopifyObjectDataset"/>, <see cref="SnowflakeDataset"/>, <see cref="SnowflakeV2Dataset"/>, <see cref="SparkObjectDataset"/>, <see cref="SqlServerTableDataset"/>, <see cref="SquareObjectDataset"/>, <see cref="SybaseTableDataset"/>, <see cref="TeradataTableDataset"/>, <see cref="VerticaTableDataset"/>, <see cref="WarehouseTableDataset"/>, <see cref="WebTableDataset"/>, <see cref="XeroObjectDataset"/>, <see cref="XmlDataset"/> and <see cref="ZohoObjectDataset"/>.
        /// </param>
        /// <returns> A new <see cref="Models.DataFactoryDatasetDebugInfo"/> instance for mocking. </returns>
        public static DataFactoryDatasetDebugInfo DataFactoryDatasetDebugInfo(string name = null, DataFactoryDatasetProperties properties = null)
        {
            return new DataFactoryDatasetDebugInfo(name, serializedAdditionalRawData: null, properties);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataFactoryLinkedServiceDebugInfo"/>. </summary>
        /// <param name="name"> The resource name. </param>
        /// <param name="properties">
        /// Properties of linked service.
        /// Please note <see cref="DataFactoryLinkedServiceProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AmazonMwsLinkedService"/>, <see cref="AmazonRdsForOracleLinkedService"/>, <see cref="AmazonRdsForSqlServerLinkedService"/>, <see cref="AmazonRedshiftLinkedService"/>, <see cref="AmazonS3LinkedService"/>, <see cref="AmazonS3CompatibleLinkedService"/>, <see cref="AppFiguresLinkedService"/>, <see cref="AsanaLinkedService"/>, <see cref="AzureBatchLinkedService"/>, <see cref="AzureBlobFSLinkedService"/>, <see cref="AzureBlobStorageLinkedService"/>, <see cref="AzureDatabricksLinkedService"/>, <see cref="AzureDatabricksDeltaLakeLinkedService"/>, <see cref="AzureDataExplorerLinkedService"/>, <see cref="AzureDataLakeAnalyticsLinkedService"/>, <see cref="AzureDataLakeStoreLinkedService"/>, <see cref="AzureFileStorageLinkedService"/>, <see cref="AzureFunctionLinkedService"/>, <see cref="AzureKeyVaultLinkedService"/>, <see cref="AzureMariaDBLinkedService"/>, <see cref="AzureMLLinkedService"/>, <see cref="AzureMLServiceLinkedService"/>, <see cref="AzureMySqlLinkedService"/>, <see cref="AzurePostgreSqlLinkedService"/>, <see cref="AzureSearchLinkedService"/>, <see cref="AzureSqlDatabaseLinkedService"/>, <see cref="AzureSqlDWLinkedService"/>, <see cref="AzureSqlMILinkedService"/>, <see cref="AzureStorageLinkedService"/>, <see cref="AzureSynapseArtifactsLinkedService"/>, <see cref="AzureTableStorageLinkedService"/>, <see cref="CassandraLinkedService"/>, <see cref="CommonDataServiceForAppsLinkedService"/>, <see cref="ConcurLinkedService"/>, <see cref="CosmosDBLinkedService"/>, <see cref="CosmosDBMongoDBApiLinkedService"/>, <see cref="CouchbaseLinkedService"/>, <see cref="CustomDataSourceLinkedService"/>, <see cref="DataworldLinkedService"/>, <see cref="Db2LinkedService"/>, <see cref="DrillLinkedService"/>, <see cref="DynamicsLinkedService"/>, <see cref="DynamicsAXLinkedService"/>, <see cref="DynamicsCrmLinkedService"/>, <see cref="EloquaLinkedService"/>, <see cref="FileServerLinkedService"/>, <see cref="FtpServerLinkedService"/>, <see cref="GoogleAdWordsLinkedService"/>, <see cref="GoogleBigQueryLinkedService"/>, <see cref="GoogleBigQueryV2LinkedService"/>, <see cref="GoogleCloudStorageLinkedService"/>, <see cref="GoogleSheetsLinkedService"/>, <see cref="GreenplumLinkedService"/>, <see cref="HBaseLinkedService"/>, <see cref="HdfsLinkedService"/>, <see cref="HDInsightLinkedService"/>, <see cref="HDInsightOnDemandLinkedService"/>, <see cref="HiveLinkedService"/>, <see cref="HttpLinkedService"/>, <see cref="HubspotLinkedService"/>, <see cref="ImpalaLinkedService"/>, <see cref="InformixLinkedService"/>, <see cref="JiraLinkedService"/>, <see cref="LakeHouseLinkedService"/>, <see cref="MagentoLinkedService"/>, <see cref="MariaDBLinkedService"/>, <see cref="MarketoLinkedService"/>, <see cref="MicrosoftAccessLinkedService"/>, <see cref="MongoDBLinkedService"/>, <see cref="MongoDBAtlasLinkedService"/>, <see cref="MongoDBV2LinkedService"/>, <see cref="MySqlLinkedService"/>, <see cref="NetezzaLinkedService"/>, <see cref="ODataLinkedService"/>, <see cref="OdbcLinkedService"/>, <see cref="Office365LinkedService"/>, <see cref="OracleLinkedService"/>, <see cref="OracleCloudStorageLinkedService"/>, <see cref="OracleServiceCloudLinkedService"/>, <see cref="PaypalLinkedService"/>, <see cref="PhoenixLinkedService"/>, <see cref="PostgreSqlLinkedService"/>, <see cref="PostgreSqlV2LinkedService"/>, <see cref="PrestoLinkedService"/>, <see cref="QuickbaseLinkedService"/>, <see cref="QuickBooksLinkedService"/>, <see cref="ResponsysLinkedService"/>, <see cref="RestServiceLinkedService"/>, <see cref="SalesforceLinkedService"/>, <see cref="SalesforceMarketingCloudLinkedService"/>, <see cref="SalesforceServiceCloudLinkedService"/>, <see cref="SalesforceServiceCloudV2LinkedService"/>, <see cref="SalesforceV2LinkedService"/>, <see cref="SapBWLinkedService"/>, <see cref="SapCloudForCustomerLinkedService"/>, <see cref="SapEccLinkedService"/>, <see cref="SapHanaLinkedService"/>, <see cref="SapOdpLinkedService"/>, <see cref="SapOpenHubLinkedService"/>, <see cref="SapTableLinkedService"/>, <see cref="ServiceNowLinkedService"/>, <see cref="ServiceNowV2LinkedService"/>, <see cref="SftpServerLinkedService"/>, <see cref="SharePointOnlineListLinkedService"/>, <see cref="ShopifyLinkedService"/>, <see cref="SmartsheetLinkedService"/>, <see cref="SnowflakeLinkedService"/>, <see cref="SnowflakeV2LinkedService"/>, <see cref="SparkLinkedService"/>, <see cref="SqlServerLinkedService"/>, <see cref="SquareLinkedService"/>, <see cref="SybaseLinkedService"/>, <see cref="TeamDeskLinkedService"/>, <see cref="TeradataLinkedService"/>, <see cref="TwilioLinkedService"/>, <see cref="VerticaLinkedService"/>, <see cref="WarehouseLinkedService"/>, <see cref="WebLinkedService"/>, <see cref="XeroLinkedService"/>, <see cref="ZendeskLinkedService"/> and <see cref="ZohoLinkedService"/>.
        /// </param>
        /// <returns> A new <see cref="Models.DataFactoryLinkedServiceDebugInfo"/> instance for mocking. </returns>
        public static DataFactoryLinkedServiceDebugInfo DataFactoryLinkedServiceDebugInfo(string name = null, DataFactoryLinkedServiceProperties properties = null)
        {
            return new DataFactoryLinkedServiceDebugInfo(name, serializedAdditionalRawData: null, properties);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataFactoryDataFlowStartDebugSessionResult"/>. </summary>
        /// <param name="jobVersion"> The ID of data flow debug job version. </param>
        /// <returns> A new <see cref="Models.DataFactoryDataFlowStartDebugSessionResult"/> instance for mocking. </returns>
        public static DataFactoryDataFlowStartDebugSessionResult DataFactoryDataFlowStartDebugSessionResult(string jobVersion = null)
        {
            return new DataFactoryDataFlowStartDebugSessionResult(jobVersion, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataFlowDebugCommandPayload"/>. </summary>
        /// <param name="streamName"> The stream name which is used for preview. </param>
        /// <param name="rowLimits"> Row limits for preview response. </param>
        /// <param name="columns"> Array of column names. </param>
        /// <param name="expression"> The expression which is used for preview. </param>
        /// <returns> A new <see cref="Models.DataFlowDebugCommandPayload"/> instance for mocking. </returns>
        public static DataFlowDebugCommandPayload DataFlowDebugCommandPayload(string streamName = null, int? rowLimits = null, IEnumerable<string> columns = null, string expression = null)
        {
            columns ??= new List<string>();

            return new DataFlowDebugCommandPayload(streamName, rowLimits, columns?.ToList(), expression, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataFactoryDataFlowDebugCommandResult"/>. </summary>
        /// <param name="status"> The run status of data preview, statistics or expression preview. </param>
        /// <param name="data"> The result data of data preview, statistics or expression preview. </param>
        /// <returns> A new <see cref="Models.DataFactoryDataFlowDebugCommandResult"/> instance for mocking. </returns>
        public static DataFactoryDataFlowDebugCommandResult DataFactoryDataFlowDebugCommandResult(string status = null, string data = null)
        {
            return new DataFactoryDataFlowDebugCommandResult(status, data, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DataFactory.DataFactoryManagedVirtualNetworkData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> Managed Virtual Network properties. </param>
        /// <param name="eTag"> Etag identifies change in the resource. </param>
        /// <returns> A new <see cref="DataFactory.DataFactoryManagedVirtualNetworkData"/> instance for mocking. </returns>
        public static DataFactoryManagedVirtualNetworkData DataFactoryManagedVirtualNetworkData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, DataFactoryManagedVirtualNetworkProperties properties = null, ETag? eTag = null)
        {
            return new DataFactoryManagedVirtualNetworkData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                eTag,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataFactoryManagedVirtualNetworkProperties"/>. </summary>
        /// <param name="vnetId"> Managed Virtual Network ID. </param>
        /// <param name="alias"> Managed Virtual Network alias. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <returns> A new <see cref="Models.DataFactoryManagedVirtualNetworkProperties"/> instance for mocking. </returns>
        public static DataFactoryManagedVirtualNetworkProperties DataFactoryManagedVirtualNetworkProperties(Guid? vnetId = null, string @alias = null, IDictionary<string, BinaryData> additionalProperties = null)
        {
            additionalProperties ??= new Dictionary<string, BinaryData>();

            return new DataFactoryManagedVirtualNetworkProperties(vnetId, @alias, additionalProperties);
        }

        /// <summary> Initializes a new instance of <see cref="DataFactory.DataFactoryPrivateEndpointData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> Managed private endpoint properties. </param>
        /// <param name="eTag"> Etag identifies change in the resource. </param>
        /// <returns> A new <see cref="DataFactory.DataFactoryPrivateEndpointData"/> instance for mocking. </returns>
        public static DataFactoryPrivateEndpointData DataFactoryPrivateEndpointData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, DataFactoryPrivateEndpointProperties properties = null, ETag? eTag = null)
        {
            return new DataFactoryPrivateEndpointData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                eTag,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataFactoryPrivateEndpointProperties"/>. </summary>
        /// <param name="connectionState"> The managed private endpoint connection state. </param>
        /// <param name="fqdns"> Fully qualified domain names. </param>
        /// <param name="groupId"> The groupId to which the managed private endpoint is created. </param>
        /// <param name="isReserved"> Denotes whether the managed private endpoint is reserved. </param>
        /// <param name="privateLinkResourceId"> The ARM resource ID of the resource to which the managed private endpoint is created. </param>
        /// <param name="provisioningState"> The managed private endpoint provisioning state. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <returns> A new <see cref="Models.DataFactoryPrivateEndpointProperties"/> instance for mocking. </returns>
        public static DataFactoryPrivateEndpointProperties DataFactoryPrivateEndpointProperties(ConnectionStateProperties connectionState = null, IEnumerable<string> fqdns = null, string groupId = null, bool? isReserved = null, ResourceIdentifier privateLinkResourceId = null, string provisioningState = null, IDictionary<string, BinaryData> additionalProperties = null)
        {
            fqdns ??= new List<string>();
            additionalProperties ??= new Dictionary<string, BinaryData>();

            return new DataFactoryPrivateEndpointProperties(
                connectionState,
                fqdns?.ToList(),
                groupId,
                isReserved,
                privateLinkResourceId,
                provisioningState,
                additionalProperties);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConnectionStateProperties"/>. </summary>
        /// <param name="actionsRequired"> The actions required on the managed private endpoint. </param>
        /// <param name="description"> The managed private endpoint description. </param>
        /// <param name="status"> The approval status. </param>
        /// <returns> A new <see cref="Models.ConnectionStateProperties"/> instance for mocking. </returns>
        public static ConnectionStateProperties ConnectionStateProperties(string actionsRequired = null, string description = null, string status = null)
        {
            return new ConnectionStateProperties(actionsRequired, description, status, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DataFactory.DataFactoryServiceCredentialData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties">
        /// Properties of credentials.
        /// Please note <see cref="DataFactoryCredential"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="DataFactoryManagedIdentityCredentialProperties"/> and <see cref="ServicePrincipalCredential"/>.
        /// </param>
        /// <param name="eTag"> Etag identifies change in the resource. </param>
        /// <returns> A new <see cref="DataFactory.DataFactoryServiceCredentialData"/> instance for mocking. </returns>
        public static DataFactoryServiceCredentialData DataFactoryServiceCredentialData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, DataFactoryCredential properties = null, ETag? eTag = null)
        {
            return new DataFactoryServiceCredentialData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                eTag,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DataFactory.DataFactoryPrivateEndpointConnectionData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> Core resource properties. </param>
        /// <param name="eTag"> Etag identifies change in the resource. </param>
        /// <returns> A new <see cref="DataFactory.DataFactoryPrivateEndpointConnectionData"/> instance for mocking. </returns>
        public static DataFactoryPrivateEndpointConnectionData DataFactoryPrivateEndpointConnectionData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, DataFactoryPrivateEndpointConnectionProperties properties = null, ETag? eTag = null)
        {
            return new DataFactoryPrivateEndpointConnectionData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                eTag,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataFactoryPrivateEndpointConnectionProperties"/>. </summary>
        /// <param name="provisioningState"></param>
        /// <param name="privateEndpointId"> PrivateEndpoint of a remote private endpoint connection. </param>
        /// <param name="privateLinkServiceConnectionState"> The state of a private link connection. </param>
        /// <returns> A new <see cref="Models.DataFactoryPrivateEndpointConnectionProperties"/> instance for mocking. </returns>
        public static DataFactoryPrivateEndpointConnectionProperties DataFactoryPrivateEndpointConnectionProperties(string provisioningState = null, ResourceIdentifier privateEndpointId = null, PrivateLinkConnectionState privateLinkServiceConnectionState = null)
        {
            return new DataFactoryPrivateEndpointConnectionProperties(provisioningState, privateEndpointId != null ? ResourceManagerModelFactory.SubResource(privateEndpointId) : null, privateLinkServiceConnectionState, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataFactoryPrivateEndpointConnectionCreateOrUpdateContent"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> Core resource properties. </param>
        /// <param name="eTag"> Etag identifies change in the resource. </param>
        /// <returns> A new <see cref="Models.DataFactoryPrivateEndpointConnectionCreateOrUpdateContent"/> instance for mocking. </returns>
        public static DataFactoryPrivateEndpointConnectionCreateOrUpdateContent DataFactoryPrivateEndpointConnectionCreateOrUpdateContent(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, PrivateLinkConnectionApprovalRequest properties = null, ETag? eTag = null)
        {
            return new DataFactoryPrivateEndpointConnectionCreateOrUpdateContent(
                id,
                name,
                resourceType,
                systemData,
                properties,
                eTag,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataFactoryPrivateLinkResource"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> Core resource properties. </param>
        /// <param name="eTag"> Etag identifies change in the resource. </param>
        /// <returns> A new <see cref="Models.DataFactoryPrivateLinkResource"/> instance for mocking. </returns>
        public static DataFactoryPrivateLinkResource DataFactoryPrivateLinkResource(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, DataFactoryPrivateLinkResourceProperties properties = null, ETag? eTag = null)
        {
            return new DataFactoryPrivateLinkResource(
                id,
                name,
                resourceType,
                systemData,
                properties,
                eTag,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataFactoryPrivateLinkResourceProperties"/>. </summary>
        /// <param name="groupId"> GroupId of a private link resource. </param>
        /// <param name="requiredMembers"> RequiredMembers of a private link resource. </param>
        /// <param name="requiredZoneNames"> RequiredZoneNames of a private link resource. </param>
        /// <returns> A new <see cref="Models.DataFactoryPrivateLinkResourceProperties"/> instance for mocking. </returns>
        public static DataFactoryPrivateLinkResourceProperties DataFactoryPrivateLinkResourceProperties(string groupId = null, IEnumerable<string> requiredMembers = null, IEnumerable<string> requiredZoneNames = null)
        {
            requiredMembers ??= new List<string>();
            requiredZoneNames ??= new List<string>();

            return new DataFactoryPrivateLinkResourceProperties(groupId, requiredMembers?.ToList(), requiredZoneNames?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DataFactory.DataFactoryGlobalParameterData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> Properties of the global parameter. </param>
        /// <param name="eTag"> Etag identifies change in the resource. </param>
        /// <returns> A new <see cref="DataFactory.DataFactoryGlobalParameterData"/> instance for mocking. </returns>
        public static DataFactoryGlobalParameterData DataFactoryGlobalParameterData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, DataFactoryGlobalParameterProperties> properties = null, ETag? eTag = null)
        {
            properties ??= new Dictionary<string, DataFactoryGlobalParameterProperties>();

            return new DataFactoryGlobalParameterData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                eTag,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DataFactory.DataFactoryChangeDataCaptureData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="folderName"> The folder that this CDC is in. If not specified, CDC will appear at the root level. </param>
        /// <param name="description"> The description of the change data capture. </param>
        /// <param name="sourceConnectionsInfo"> List of sources connections that can be used as sources in the CDC. </param>
        /// <param name="targetConnectionsInfo"> List of target connections that can be used as sources in the CDC. </param>
        /// <param name="policy"> CDC policy. </param>
        /// <param name="allowVnetOverride"> A boolean to determine if the vnet configuration needs to be overwritten. </param>
        /// <param name="status"> Status of the CDC as to if it is running or stopped. </param>
        /// <param name="eTag"> Etag identifies change in the resource. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <returns> A new <see cref="DataFactory.DataFactoryChangeDataCaptureData"/> instance for mocking. </returns>
        public static DataFactoryChangeDataCaptureData DataFactoryChangeDataCaptureData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string folderName = null, string description = null, IEnumerable<MapperSourceConnectionsInfo> sourceConnectionsInfo = null, IEnumerable<MapperTargetConnectionsInfo> targetConnectionsInfo = null, MapperPolicy policy = null, bool? allowVnetOverride = null, string status = null, ETag? eTag = null, IDictionary<string, BinaryData> additionalProperties = null)
        {
            sourceConnectionsInfo ??= new List<MapperSourceConnectionsInfo>();
            targetConnectionsInfo ??= new List<MapperTargetConnectionsInfo>();
            additionalProperties ??= new Dictionary<string, BinaryData>();

            return new DataFactoryChangeDataCaptureData(
                id,
                name,
                resourceType,
                systemData,
                folderName != null ? new ChangeDataCaptureFolder(folderName, serializedAdditionalRawData: null) : null,
                description,
                sourceConnectionsInfo?.ToList(),
                targetConnectionsInfo?.ToList(),
                policy,
                allowVnetOverride,
                status,
                eTag,
                additionalProperties);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ManagedIntegrationRuntime"/>. </summary>
        /// <param name="description"> Integration runtime description. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="state"> Integration runtime state, only valid for managed dedicated integration runtime. </param>
        /// <param name="managedVirtualNetwork"> Managed Virtual Network reference. </param>
        /// <param name="computeProperties"> The compute resource for managed integration runtime. </param>
        /// <param name="ssisProperties"> SSIS properties for managed integration runtime. </param>
        /// <param name="customerVirtualNetworkSubnetId"> The name of virtual network to which Azure-SSIS integration runtime will join. </param>
        /// <returns> A new <see cref="Models.ManagedIntegrationRuntime"/> instance for mocking. </returns>
        public static ManagedIntegrationRuntime ManagedIntegrationRuntime(string description = null, IDictionary<string, BinaryData> additionalProperties = null, IntegrationRuntimeState? state = null, ManagedVirtualNetworkReference managedVirtualNetwork = null, IntegrationRuntimeComputeProperties computeProperties = null, IntegrationRuntimeSsisProperties ssisProperties = null, ResourceIdentifier customerVirtualNetworkSubnetId = null)
        {
            additionalProperties ??= new Dictionary<string, BinaryData>();

            return new ManagedIntegrationRuntime(
                IntegrationRuntimeType.Managed,
                description,
                additionalProperties,
                state,
                managedVirtualNetwork,
                computeProperties,
                ssisProperties,
                customerVirtualNetworkSubnetId != null ? new IntegrationRuntimeCustomerVirtualNetwork(customerVirtualNetworkSubnetId, serializedAdditionalRawData: null) : null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ManagedIntegrationRuntimeStatus"/>. </summary>
        /// <param name="dataFactoryName"> The data factory name which the integration runtime belong to. </param>
        /// <param name="state"> The state of integration runtime. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="createdOn"> The time at which the integration runtime was created, in ISO8601 format. </param>
        /// <param name="nodes"> The list of nodes for managed integration runtime. </param>
        /// <param name="otherErrors"> The errors that occurred on this integration runtime. </param>
        /// <param name="lastOperation"> The last operation result that occurred on this integration runtime. </param>
        /// <returns> A new <see cref="Models.ManagedIntegrationRuntimeStatus"/> instance for mocking. </returns>
        public static ManagedIntegrationRuntimeStatus ManagedIntegrationRuntimeStatus(string dataFactoryName = null, IntegrationRuntimeState? state = null, IReadOnlyDictionary<string, BinaryData> additionalProperties = null, DateTimeOffset? createdOn = null, IEnumerable<ManagedIntegrationRuntimeNode> nodes = null, IEnumerable<ManagedIntegrationRuntimeError> otherErrors = null, ManagedIntegrationRuntimeOperationResult lastOperation = null)
        {
            additionalProperties ??= new Dictionary<string, BinaryData>();
            nodes ??= new List<ManagedIntegrationRuntimeNode>();
            otherErrors ??= new List<ManagedIntegrationRuntimeError>();

            return new ManagedIntegrationRuntimeStatus(
                IntegrationRuntimeType.Managed,
                dataFactoryName,
                state,
                additionalProperties,
                createdOn,
                nodes?.ToList(),
                otherErrors?.ToList(),
                lastOperation);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ManagedIntegrationRuntimeNode"/>. </summary>
        /// <param name="nodeId"> The managed integration runtime node id. </param>
        /// <param name="status"> The managed integration runtime node status. </param>
        /// <param name="errors"> The errors that occurred on this integration runtime node. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <returns> A new <see cref="Models.ManagedIntegrationRuntimeNode"/> instance for mocking. </returns>
        public static ManagedIntegrationRuntimeNode ManagedIntegrationRuntimeNode(string nodeId = null, ManagedIntegrationRuntimeNodeStatus? status = null, IEnumerable<ManagedIntegrationRuntimeError> errors = null, IReadOnlyDictionary<string, BinaryData> additionalProperties = null)
        {
            errors ??= new List<ManagedIntegrationRuntimeError>();
            additionalProperties ??= new Dictionary<string, BinaryData>();

            return new ManagedIntegrationRuntimeNode(nodeId, status, errors?.ToList(), additionalProperties);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ManagedIntegrationRuntimeError"/>. </summary>
        /// <param name="time"> The time when the error occurred. </param>
        /// <param name="code"> Error code. </param>
        /// <param name="parameters"> Managed integration runtime error parameters. </param>
        /// <param name="message"> Error message. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <returns> A new <see cref="Models.ManagedIntegrationRuntimeError"/> instance for mocking. </returns>
        public static ManagedIntegrationRuntimeError ManagedIntegrationRuntimeError(DateTimeOffset? time = null, string code = null, IEnumerable<string> parameters = null, string message = null, IReadOnlyDictionary<string, BinaryData> additionalProperties = null)
        {
            parameters ??= new List<string>();
            additionalProperties ??= new Dictionary<string, BinaryData>();

            return new ManagedIntegrationRuntimeError(time, code, parameters?.ToList(), message, additionalProperties);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ManagedIntegrationRuntimeOperationResult"/>. </summary>
        /// <param name="managedIntegrationRuntimeOperationResultType"> The operation type. Could be start or stop. </param>
        /// <param name="startOn"> The start time of the operation. </param>
        /// <param name="result"> The operation result. </param>
        /// <param name="errorCode"> The error code. </param>
        /// <param name="parameters"> Managed integration runtime error parameters. </param>
        /// <param name="activityId"> The activity id for the operation request. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <returns> A new <see cref="Models.ManagedIntegrationRuntimeOperationResult"/> instance for mocking. </returns>
        public static ManagedIntegrationRuntimeOperationResult ManagedIntegrationRuntimeOperationResult(string managedIntegrationRuntimeOperationResultType = null, DateTimeOffset? startOn = null, string result = null, string errorCode = null, IEnumerable<string> parameters = null, string activityId = null, IReadOnlyDictionary<string, BinaryData> additionalProperties = null)
        {
            parameters ??= new List<string>();
            additionalProperties ??= new Dictionary<string, BinaryData>();

            return new ManagedIntegrationRuntimeOperationResult(
                managedIntegrationRuntimeOperationResultType,
                startOn,
                result,
                errorCode,
                parameters?.ToList(),
                activityId,
                additionalProperties);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SelfHostedIntegrationRuntimeStatus"/>. </summary>
        /// <param name="dataFactoryName"> The data factory name which the integration runtime belong to. </param>
        /// <param name="state"> The state of integration runtime. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="createdOn"> The time at which the integration runtime was created, in ISO8601 format. </param>
        /// <param name="taskQueueId"> The task queue id of the integration runtime. </param>
        /// <param name="internalChannelEncryption"> It is used to set the encryption mode for node-node communication channel (when more than 2 self-hosted integration runtime nodes exist). </param>
        /// <param name="version"> Version of the integration runtime. </param>
        /// <param name="nodes"> The list of nodes for this integration runtime. </param>
        /// <param name="scheduledUpdateOn"> The date at which the integration runtime will be scheduled to update, in ISO8601 format. </param>
        /// <param name="updateDelayOffset"> The time in the date scheduled by service to update the integration runtime, e.g., PT03H is 3 hours. </param>
        /// <param name="localTimeZoneOffset"> The local time zone offset in hours. </param>
        /// <param name="capabilities"> Object with additional information about integration runtime capabilities. </param>
        /// <param name="serviceUriStringList"> The URLs for the services used in integration runtime backend service. </param>
        /// <param name="autoUpdate"> Whether Self-hosted integration runtime auto update has been turned on. </param>
        /// <param name="versionStatus"> Status of the integration runtime version. </param>
        /// <param name="links"> The list of linked integration runtimes that are created to share with this integration runtime. </param>
        /// <param name="pushedVersion"> The version that the integration runtime is going to update to. </param>
        /// <param name="latestVersion"> The latest version on download center. </param>
        /// <param name="autoUpdateEta"> The estimated time when the self-hosted integration runtime will be updated. </param>
        /// <param name="isSelfContainedInteractiveAuthoringEnabled"> An alternative option to ensure interactive authoring function when your self-hosted integration runtime is unable to establish a connection with Azure Relay. </param>
        /// <returns> A new <see cref="Models.SelfHostedIntegrationRuntimeStatus"/> instance for mocking. </returns>
        public static SelfHostedIntegrationRuntimeStatus SelfHostedIntegrationRuntimeStatus(string dataFactoryName = null, IntegrationRuntimeState? state = null, IReadOnlyDictionary<string, BinaryData> additionalProperties = null, DateTimeOffset? createdOn = null, Guid? taskQueueId = null, IntegrationRuntimeInternalChannelEncryptionMode? internalChannelEncryption = null, string version = null, IEnumerable<SelfHostedIntegrationRuntimeNode> nodes = null, DateTimeOffset? scheduledUpdateOn = null, TimeSpan? updateDelayOffset = null, TimeSpan? localTimeZoneOffset = null, IReadOnlyDictionary<string, string> capabilities = null, IEnumerable<string> serviceUriStringList = null, IntegrationRuntimeAutoUpdateState? autoUpdate = null, string versionStatus = null, IEnumerable<LinkedIntegrationRuntime> links = null, string pushedVersion = null, string latestVersion = null, DateTimeOffset? autoUpdateEta = null, bool? isSelfContainedInteractiveAuthoringEnabled = null)
        {
            additionalProperties ??= new Dictionary<string, BinaryData>();
            nodes ??= new List<SelfHostedIntegrationRuntimeNode>();
            capabilities ??= new Dictionary<string, string>();
            serviceUriStringList ??= new List<string>();
            links ??= new List<LinkedIntegrationRuntime>();

            return new SelfHostedIntegrationRuntimeStatus(
                IntegrationRuntimeType.SelfHosted,
                dataFactoryName,
                state,
                additionalProperties,
                createdOn,
                taskQueueId,
                internalChannelEncryption,
                version,
                nodes?.ToList(),
                scheduledUpdateOn,
                updateDelayOffset,
                localTimeZoneOffset,
                capabilities,
                serviceUriStringList?.ToList(),
                autoUpdate,
                versionStatus,
                links?.ToList(),
                pushedVersion,
                latestVersion,
                autoUpdateEta,
                isSelfContainedInteractiveAuthoringEnabled);
        }

        /// <summary> Initializes a new instance of <see cref="Models.LinkedIntegrationRuntime"/>. </summary>
        /// <param name="name"> The name of the linked integration runtime. </param>
        /// <param name="subscriptionId"> The subscription ID for which the linked integration runtime belong to. </param>
        /// <param name="dataFactoryName"> The name of the data factory for which the linked integration runtime belong to. </param>
        /// <param name="dataFactoryLocation"> The location of the data factory for which the linked integration runtime belong to. </param>
        /// <param name="createdOn"> The creating time of the linked integration runtime. </param>
        /// <returns> A new <see cref="Models.LinkedIntegrationRuntime"/> instance for mocking. </returns>
        public static LinkedIntegrationRuntime LinkedIntegrationRuntime(string name = null, string subscriptionId = null, string dataFactoryName = null, AzureLocation? dataFactoryLocation = null, DateTimeOffset? createdOn = null)
        {
            return new LinkedIntegrationRuntime(
                name,
                subscriptionId,
                dataFactoryName,
                dataFactoryLocation,
                createdOn,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SsisFolder"/>. </summary>
        /// <param name="id"> Metadata id. </param>
        /// <param name="name"> Metadata name. </param>
        /// <param name="description"> Metadata description. </param>
        /// <returns> A new <see cref="Models.SsisFolder"/> instance for mocking. </returns>
        public static SsisFolder SsisFolder(long? id = null, string name = null, string description = null)
        {
            return new SsisFolder(SsisObjectMetadataType.Folder, id, name, description, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SsisProject"/>. </summary>
        /// <param name="id"> Metadata id. </param>
        /// <param name="name"> Metadata name. </param>
        /// <param name="description"> Metadata description. </param>
        /// <param name="folderId"> Folder id which contains project. </param>
        /// <param name="version"> Project version. </param>
        /// <param name="environmentRefs"> Environment reference in project. </param>
        /// <param name="parameters"> Parameters in project. </param>
        /// <returns> A new <see cref="Models.SsisProject"/> instance for mocking. </returns>
        public static SsisProject SsisProject(long? id = null, string name = null, string description = null, long? folderId = null, long? version = null, IEnumerable<SsisEnvironmentReference> environmentRefs = null, IEnumerable<SsisParameterInfo> parameters = null)
        {
            environmentRefs ??= new List<SsisEnvironmentReference>();
            parameters ??= new List<SsisParameterInfo>();

            return new SsisProject(
                SsisObjectMetadataType.Project,
                id,
                name,
                description,
                serializedAdditionalRawData: null,
                folderId,
                version,
                environmentRefs?.ToList(),
                parameters?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.SsisEnvironmentReference"/>. </summary>
        /// <param name="id"> Environment reference id. </param>
        /// <param name="environmentFolderName"> Environment folder name. </param>
        /// <param name="environmentName"> Environment name. </param>
        /// <param name="referenceType"> Reference type. </param>
        /// <returns> A new <see cref="Models.SsisEnvironmentReference"/> instance for mocking. </returns>
        public static SsisEnvironmentReference SsisEnvironmentReference(long? id = null, string environmentFolderName = null, string environmentName = null, string referenceType = null)
        {
            return new SsisEnvironmentReference(id, environmentFolderName, environmentName, referenceType, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SsisParameterInfo"/>. </summary>
        /// <param name="id"> Parameter id. </param>
        /// <param name="name"> Parameter name. </param>
        /// <param name="description"> Parameter description. </param>
        /// <param name="dataType"> Parameter type. </param>
        /// <param name="isRequired"> Whether parameter is required. </param>
        /// <param name="isSensitive"> Whether parameter is sensitive. </param>
        /// <param name="designDefaultValue"> Design default value of parameter. </param>
        /// <param name="defaultValue"> Default value of parameter. </param>
        /// <param name="sensitiveDefaultValue"> Default sensitive value of parameter. </param>
        /// <param name="valueType"> Parameter value type. </param>
        /// <param name="hasValueSet"> Parameter value set. </param>
        /// <param name="variable"> Parameter reference variable. </param>
        /// <returns> A new <see cref="Models.SsisParameterInfo"/> instance for mocking. </returns>
        public static SsisParameterInfo SsisParameterInfo(long? id = null, string name = null, string description = null, string dataType = null, bool? isRequired = null, bool? isSensitive = null, string designDefaultValue = null, string defaultValue = null, string sensitiveDefaultValue = null, string valueType = null, bool? hasValueSet = null, string variable = null)
        {
            return new SsisParameterInfo(
                id,
                name,
                description,
                dataType,
                isRequired,
                isSensitive,
                designDefaultValue,
                defaultValue,
                sensitiveDefaultValue,
                valueType,
                hasValueSet,
                variable,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SsisPackage"/>. </summary>
        /// <param name="id"> Metadata id. </param>
        /// <param name="name"> Metadata name. </param>
        /// <param name="description"> Metadata description. </param>
        /// <param name="folderId"> Folder id which contains package. </param>
        /// <param name="projectVersion"> Project version which contains package. </param>
        /// <param name="projectId"> Project id which contains package. </param>
        /// <param name="parameters"> Parameters in package. </param>
        /// <returns> A new <see cref="Models.SsisPackage"/> instance for mocking. </returns>
        public static SsisPackage SsisPackage(long? id = null, string name = null, string description = null, long? folderId = null, long? projectVersion = null, long? projectId = null, IEnumerable<SsisParameterInfo> parameters = null)
        {
            parameters ??= new List<SsisParameterInfo>();

            return new SsisPackage(
                SsisObjectMetadataType.Package,
                id,
                name,
                description,
                serializedAdditionalRawData: null,
                folderId,
                projectVersion,
                projectId,
                parameters?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.SsisEnvironment"/>. </summary>
        /// <param name="id"> Metadata id. </param>
        /// <param name="name"> Metadata name. </param>
        /// <param name="description"> Metadata description. </param>
        /// <param name="folderId"> Folder id which contains environment. </param>
        /// <param name="variables"> Variable in environment. </param>
        /// <returns> A new <see cref="Models.SsisEnvironment"/> instance for mocking. </returns>
        public static SsisEnvironment SsisEnvironment(long? id = null, string name = null, string description = null, long? folderId = null, IEnumerable<SsisVariable> variables = null)
        {
            variables ??= new List<SsisVariable>();

            return new SsisEnvironment(
                SsisObjectMetadataType.Environment,
                id,
                name,
                description,
                serializedAdditionalRawData: null,
                folderId,
                variables?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.SsisVariable"/>. </summary>
        /// <param name="id"> Variable id. </param>
        /// <param name="name"> Variable name. </param>
        /// <param name="description"> Variable description. </param>
        /// <param name="dataType"> Variable type. </param>
        /// <param name="isSensitive"> Whether variable is sensitive. </param>
        /// <param name="value"> Variable value. </param>
        /// <param name="sensitiveValue"> Variable sensitive value. </param>
        /// <returns> A new <see cref="Models.SsisVariable"/> instance for mocking. </returns>
        public static SsisVariable SsisVariable(long? id = null, string name = null, string description = null, string dataType = null, bool? isSensitive = null, string value = null, string sensitiveValue = null)
        {
            return new SsisVariable(
                id,
                name,
                description,
                dataType,
                isSensitive,
                value,
                sensitiveValue,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MultiplePipelineTrigger"/>. </summary>
        /// <param name="description"> Trigger description. </param>
        /// <param name="runtimeState"> Indicates if trigger is running or not. Updated when Start/Stop APIs are called on the Trigger. </param>
        /// <param name="annotations"> List of tags that can be used for describing the trigger. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="pipelines"> Pipelines that need to be started. </param>
        /// <returns> A new <see cref="Models.MultiplePipelineTrigger"/> instance for mocking. </returns>
        public static MultiplePipelineTrigger MultiplePipelineTrigger(string description = null, DataFactoryTriggerRuntimeState? runtimeState = null, IEnumerable<BinaryData> annotations = null, IDictionary<string, BinaryData> additionalProperties = null, IEnumerable<TriggerPipelineReference> pipelines = null)
        {
            annotations ??= new List<BinaryData>();
            additionalProperties ??= new Dictionary<string, BinaryData>();
            pipelines ??= new List<TriggerPipelineReference>();

            return new MultiplePipelineTrigger(
                "MultiplePipelineTrigger",
                description,
                runtimeState,
                annotations?.ToList(),
                additionalProperties,
                pipelines?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataFactoryScheduleTrigger"/>. </summary>
        /// <param name="description"> Trigger description. </param>
        /// <param name="runtimeState"> Indicates if trigger is running or not. Updated when Start/Stop APIs are called on the Trigger. </param>
        /// <param name="annotations"> List of tags that can be used for describing the trigger. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="pipelines"> Pipelines that need to be started. </param>
        /// <param name="recurrence"> Recurrence schedule configuration. </param>
        /// <returns> A new <see cref="Models.DataFactoryScheduleTrigger"/> instance for mocking. </returns>
        public static DataFactoryScheduleTrigger DataFactoryScheduleTrigger(string description = null, DataFactoryTriggerRuntimeState? runtimeState = null, IEnumerable<BinaryData> annotations = null, IDictionary<string, BinaryData> additionalProperties = null, IEnumerable<TriggerPipelineReference> pipelines = null, ScheduleTriggerRecurrence recurrence = null)
        {
            annotations ??= new List<BinaryData>();
            additionalProperties ??= new Dictionary<string, BinaryData>();
            pipelines ??= new List<TriggerPipelineReference>();

            return new DataFactoryScheduleTrigger(
                "ScheduleTrigger",
                description,
                runtimeState,
                annotations?.ToList(),
                additionalProperties,
                pipelines?.ToList(),
                recurrence);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataFactoryBlobTrigger"/>. </summary>
        /// <param name="description"> Trigger description. </param>
        /// <param name="runtimeState"> Indicates if trigger is running or not. Updated when Start/Stop APIs are called on the Trigger. </param>
        /// <param name="annotations"> List of tags that can be used for describing the trigger. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="pipelines"> Pipelines that need to be started. </param>
        /// <param name="folderPath"> The path of the container/folder that will trigger the pipeline. </param>
        /// <param name="maxConcurrency"> The max number of parallel files to handle when it is triggered. </param>
        /// <param name="linkedService"> The Azure Storage linked service reference. </param>
        /// <returns> A new <see cref="Models.DataFactoryBlobTrigger"/> instance for mocking. </returns>
        public static DataFactoryBlobTrigger DataFactoryBlobTrigger(string description = null, DataFactoryTriggerRuntimeState? runtimeState = null, IEnumerable<BinaryData> annotations = null, IDictionary<string, BinaryData> additionalProperties = null, IEnumerable<TriggerPipelineReference> pipelines = null, string folderPath = null, int maxConcurrency = default, DataFactoryLinkedServiceReference linkedService = null)
        {
            annotations ??= new List<BinaryData>();
            additionalProperties ??= new Dictionary<string, BinaryData>();
            pipelines ??= new List<TriggerPipelineReference>();

            return new DataFactoryBlobTrigger(
                "BlobTrigger",
                description,
                runtimeState,
                annotations?.ToList(),
                additionalProperties,
                pipelines?.ToList(),
                folderPath,
                maxConcurrency,
                linkedService);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataFactoryBlobEventsTrigger"/>. </summary>
        /// <param name="description"> Trigger description. </param>
        /// <param name="runtimeState"> Indicates if trigger is running or not. Updated when Start/Stop APIs are called on the Trigger. </param>
        /// <param name="annotations"> List of tags that can be used for describing the trigger. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="pipelines"> Pipelines that need to be started. </param>
        /// <param name="blobPathBeginsWith"> The blob path must begin with the pattern provided for trigger to fire. For example, '/records/blobs/december/' will only fire the trigger for blobs in the december folder under the records container. At least one of these must be provided: blobPathBeginsWith, blobPathEndsWith. </param>
        /// <param name="blobPathEndsWith"> The blob path must end with the pattern provided for trigger to fire. For example, 'december/boxes.csv' will only fire the trigger for blobs named boxes in a december folder. At least one of these must be provided: blobPathBeginsWith, blobPathEndsWith. </param>
        /// <param name="ignoreEmptyBlobs"> If set to true, blobs with zero bytes will be ignored. </param>
        /// <param name="events"> The type of events that cause this trigger to fire. </param>
        /// <param name="scope"> The ARM resource ID of the Storage Account. </param>
        /// <returns> A new <see cref="Models.DataFactoryBlobEventsTrigger"/> instance for mocking. </returns>
        public static DataFactoryBlobEventsTrigger DataFactoryBlobEventsTrigger(string description = null, DataFactoryTriggerRuntimeState? runtimeState = null, IEnumerable<BinaryData> annotations = null, IDictionary<string, BinaryData> additionalProperties = null, IEnumerable<TriggerPipelineReference> pipelines = null, string blobPathBeginsWith = null, string blobPathEndsWith = null, bool? ignoreEmptyBlobs = null, IEnumerable<DataFactoryBlobEventType> events = null, string scope = null)
        {
            annotations ??= new List<BinaryData>();
            additionalProperties ??= new Dictionary<string, BinaryData>();
            pipelines ??= new List<TriggerPipelineReference>();
            events ??= new List<DataFactoryBlobEventType>();

            return new DataFactoryBlobEventsTrigger(
                "BlobEventsTrigger",
                description,
                runtimeState,
                annotations?.ToList(),
                additionalProperties,
                pipelines?.ToList(),
                blobPathBeginsWith,
                blobPathEndsWith,
                ignoreEmptyBlobs,
                events?.ToList(),
                scope);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CustomEventsTrigger"/>. </summary>
        /// <param name="description"> Trigger description. </param>
        /// <param name="runtimeState"> Indicates if trigger is running or not. Updated when Start/Stop APIs are called on the Trigger. </param>
        /// <param name="annotations"> List of tags that can be used for describing the trigger. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="pipelines"> Pipelines that need to be started. </param>
        /// <param name="subjectBeginsWith"> The event subject must begin with the pattern provided for trigger to fire. At least one of these must be provided: subjectBeginsWith, subjectEndsWith. </param>
        /// <param name="subjectEndsWith"> The event subject must end with the pattern provided for trigger to fire. At least one of these must be provided: subjectBeginsWith, subjectEndsWith. </param>
        /// <param name="events"> The list of event types that cause this trigger to fire. </param>
        /// <param name="scope"> The ARM resource ID of the Azure Event Grid Topic. </param>
        /// <returns> A new <see cref="Models.CustomEventsTrigger"/> instance for mocking. </returns>
        public static CustomEventsTrigger CustomEventsTrigger(string description = null, DataFactoryTriggerRuntimeState? runtimeState = null, IEnumerable<BinaryData> annotations = null, IDictionary<string, BinaryData> additionalProperties = null, IEnumerable<TriggerPipelineReference> pipelines = null, string subjectBeginsWith = null, string subjectEndsWith = null, IEnumerable<BinaryData> events = null, string scope = null)
        {
            annotations ??= new List<BinaryData>();
            additionalProperties ??= new Dictionary<string, BinaryData>();
            pipelines ??= new List<TriggerPipelineReference>();
            events ??= new List<BinaryData>();

            return new CustomEventsTrigger(
                "CustomEventsTrigger",
                description,
                runtimeState,
                annotations?.ToList(),
                additionalProperties,
                pipelines?.ToList(),
                subjectBeginsWith,
                subjectEndsWith,
                events?.ToList(),
                scope);
        }

        /// <summary> Initializes a new instance of <see cref="Models.TumblingWindowTrigger"/>. </summary>
        /// <param name="description"> Trigger description. </param>
        /// <param name="runtimeState"> Indicates if trigger is running or not. Updated when Start/Stop APIs are called on the Trigger. </param>
        /// <param name="annotations"> List of tags that can be used for describing the trigger. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="pipeline"> Pipeline for which runs are created when an event is fired for trigger window that is ready. </param>
        /// <param name="frequency"> The frequency of the time windows. </param>
        /// <param name="interval"> The interval of the time windows. The minimum interval allowed is 15 Minutes. </param>
        /// <param name="startOn"> The start time for the time period for the trigger during which events are fired for windows that are ready. Only UTC time is currently supported. </param>
        /// <param name="endOn"> The end time for the time period for the trigger during which events are fired for windows that are ready. Only UTC time is currently supported. </param>
        /// <param name="delay"> Specifies how long the trigger waits past due time before triggering new run. It doesn't alter window start and end time. The default is 0. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])). </param>
        /// <param name="maxConcurrency"> The max number of parallel time windows (ready for execution) for which a new run is triggered. </param>
        /// <param name="retryPolicy"> Retry policy that will be applied for failed pipeline runs. </param>
        /// <param name="dependsOn">
        /// Triggers that this trigger depends on. Only tumbling window triggers are supported.
        /// Please note <see cref="DependencyReference"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="SelfDependencyTumblingWindowTriggerReference"/>, <see cref="TriggerDependencyReference"/> and <see cref="TumblingWindowTriggerDependencyReference"/>.
        /// </param>
        /// <returns> A new <see cref="Models.TumblingWindowTrigger"/> instance for mocking. </returns>
        public static TumblingWindowTrigger TumblingWindowTrigger(string description = null, DataFactoryTriggerRuntimeState? runtimeState = null, IEnumerable<BinaryData> annotations = null, IDictionary<string, BinaryData> additionalProperties = null, TriggerPipelineReference pipeline = null, TumblingWindowFrequency frequency = default, int interval = default, DateTimeOffset startOn = default, DateTimeOffset? endOn = null, DataFactoryElement<string> delay = null, int maxConcurrency = default, RetryPolicy retryPolicy = null, IEnumerable<DependencyReference> dependsOn = null)
        {
            annotations ??= new List<BinaryData>();
            additionalProperties ??= new Dictionary<string, BinaryData>();
            dependsOn ??= new List<DependencyReference>();

            return new TumblingWindowTrigger(
                "TumblingWindowTrigger",
                description,
                runtimeState,
                annotations?.ToList(),
                additionalProperties,
                pipeline,
                frequency,
                interval,
                startOn,
                endOn,
                delay,
                maxConcurrency,
                retryPolicy,
                dependsOn?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.RerunTumblingWindowTrigger"/>. </summary>
        /// <param name="description"> Trigger description. </param>
        /// <param name="runtimeState"> Indicates if trigger is running or not. Updated when Start/Stop APIs are called on the Trigger. </param>
        /// <param name="annotations"> List of tags that can be used for describing the trigger. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="parentTrigger"> The parent trigger reference. </param>
        /// <param name="requestedStartOn"> The start time for the time period for which restatement is initiated. Only UTC time is currently supported. </param>
        /// <param name="requestedEndOn"> The end time for the time period for which restatement is initiated. Only UTC time is currently supported. </param>
        /// <param name="rerunConcurrency"> The max number of parallel time windows (ready for execution) for which a rerun is triggered. </param>
        /// <returns> A new <see cref="Models.RerunTumblingWindowTrigger"/> instance for mocking. </returns>
        public static RerunTumblingWindowTrigger RerunTumblingWindowTrigger(string description = null, DataFactoryTriggerRuntimeState? runtimeState = null, IEnumerable<BinaryData> annotations = null, IDictionary<string, BinaryData> additionalProperties = null, BinaryData parentTrigger = null, DateTimeOffset requestedStartOn = default, DateTimeOffset requestedEndOn = default, int rerunConcurrency = default)
        {
            annotations ??= new List<BinaryData>();
            additionalProperties ??= new Dictionary<string, BinaryData>();

            return new RerunTumblingWindowTrigger(
                "RerunTumblingWindowTrigger",
                description,
                runtimeState,
                annotations?.ToList(),
                additionalProperties,
                parentTrigger,
                requestedStartOn,
                requestedEndOn,
                rerunConcurrency);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ChainingTrigger"/>. </summary>
        /// <param name="description"> Trigger description. </param>
        /// <param name="runtimeState"> Indicates if trigger is running or not. Updated when Start/Stop APIs are called on the Trigger. </param>
        /// <param name="annotations"> List of tags that can be used for describing the trigger. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="pipeline"> Pipeline for which runs are created when all upstream pipelines complete successfully. </param>
        /// <param name="dependsOn"> Upstream Pipelines. </param>
        /// <param name="runDimension"> Run Dimension property that needs to be emitted by upstream pipelines. </param>
        /// <returns> A new <see cref="Models.ChainingTrigger"/> instance for mocking. </returns>
        public static ChainingTrigger ChainingTrigger(string description = null, DataFactoryTriggerRuntimeState? runtimeState = null, IEnumerable<BinaryData> annotations = null, IDictionary<string, BinaryData> additionalProperties = null, TriggerPipelineReference pipeline = null, IEnumerable<DataFactoryPipelineReference> dependsOn = null, string runDimension = null)
        {
            annotations ??= new List<BinaryData>();
            additionalProperties ??= new Dictionary<string, BinaryData>();
            dependsOn ??= new List<DataFactoryPipelineReference>();

            return new ChainingTrigger(
                "ChainingTrigger",
                description,
                runtimeState,
                annotations?.ToList(),
                additionalProperties,
                pipeline,
                dependsOn?.ToList(),
                runDimension);
        }
    }
}
