// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.DataFactory.Models;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.DataFactory.Samples
{
    public partial class Sample_SubscriptionResourceExtensions
    {
        // ExposureControl_GetFeatureValue
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetFeatureValueExposureControl_ExposureControlGetFeatureValue()
        {
            // Generated from example definition: specification/datafactory/resource-manager/Microsoft.DataFactory/stable/2018-06-01/examples/ExposureControl_GetFeatureValue.json
            // this example is just showing the usage of "ExposureControl_GetFeatureValue" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionResource created on azure
            // for more information of creating SubscriptionResource, please refer to the document of SubscriptionResource
            string subscriptionId = "12345678-1234-1234-1234-12345678abc";
            ResourceIdentifier subscriptionResourceId = SubscriptionResource.CreateResourceIdentifier(subscriptionId);
            SubscriptionResource subscriptionResource = client.GetSubscriptionResource(subscriptionResourceId);

            // invoke the operation
            AzureLocation locationId = new AzureLocation("WestEurope");
            ExposureControlContent content = new ExposureControlContent()
            {
                FeatureName = "ADFIntegrationRuntimeSharingRbac",
                FeatureType = "Feature",
            };
            ExposureControlResult result = await subscriptionResource.GetFeatureValueExposureControlAsync(locationId, content);

            Console.WriteLine($"Succeeded: {result}");
        }
    }
}
