// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.DataFactory.Samples
{
    public partial class Sample_DataFactoryChangeDataCaptureResource
    {
        // ChangeDataCapture_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_ChangeDataCaptureGet()
        {
            // Generated from example definition: specification/datafactory/resource-manager/Microsoft.DataFactory/stable/2018-06-01/examples/ChangeDataCapture_Get.json
            // this example is just showing the usage of "ChangeDataCapture_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DataFactoryChangeDataCaptureResource created on azure
            // for more information of creating DataFactoryChangeDataCaptureResource, please refer to the document of DataFactoryChangeDataCaptureResource
            string subscriptionId = "12345678-1234-1234-1234-12345678abc";
            string resourceGroupName = "exampleResourceGroup";
            string factoryName = "exampleFactoryName";
            string changeDataCaptureName = "exampleChangeDataCapture";
            ResourceIdentifier dataFactoryChangeDataCaptureResourceId = DataFactoryChangeDataCaptureResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, factoryName, changeDataCaptureName);
            DataFactoryChangeDataCaptureResource dataFactoryChangeDataCapture = client.GetDataFactoryChangeDataCaptureResource(dataFactoryChangeDataCaptureResourceId);

            // invoke the operation
            DataFactoryChangeDataCaptureResource result = await dataFactoryChangeDataCapture.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            DataFactoryChangeDataCaptureData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // ChangeDataCapture_Delete
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_ChangeDataCaptureDelete()
        {
            // Generated from example definition: specification/datafactory/resource-manager/Microsoft.DataFactory/stable/2018-06-01/examples/ChangeDataCapture_Delete.json
            // this example is just showing the usage of "ChangeDataCapture_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DataFactoryChangeDataCaptureResource created on azure
            // for more information of creating DataFactoryChangeDataCaptureResource, please refer to the document of DataFactoryChangeDataCaptureResource
            string subscriptionId = "12345678-1234-1234-1234-12345678abc";
            string resourceGroupName = "exampleResourceGroup";
            string factoryName = "exampleFactoryName";
            string changeDataCaptureName = "exampleChangeDataCapture";
            ResourceIdentifier dataFactoryChangeDataCaptureResourceId = DataFactoryChangeDataCaptureResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, factoryName, changeDataCaptureName);
            DataFactoryChangeDataCaptureResource dataFactoryChangeDataCapture = client.GetDataFactoryChangeDataCaptureResource(dataFactoryChangeDataCaptureResourceId);

            // invoke the operation
            await dataFactoryChangeDataCapture.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // ChangeDataCapture_Start
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Start_ChangeDataCaptureStart()
        {
            // Generated from example definition: specification/datafactory/resource-manager/Microsoft.DataFactory/stable/2018-06-01/examples/ChangeDataCapture_Start.json
            // this example is just showing the usage of "ChangeDataCapture_Start" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DataFactoryChangeDataCaptureResource created on azure
            // for more information of creating DataFactoryChangeDataCaptureResource, please refer to the document of DataFactoryChangeDataCaptureResource
            string subscriptionId = "12345678-1234-1234-1234-12345678abc";
            string resourceGroupName = "exampleResourceGroup";
            string factoryName = "exampleFactoryName";
            string changeDataCaptureName = "exampleChangeDataCapture";
            ResourceIdentifier dataFactoryChangeDataCaptureResourceId = DataFactoryChangeDataCaptureResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, factoryName, changeDataCaptureName);
            DataFactoryChangeDataCaptureResource dataFactoryChangeDataCapture = client.GetDataFactoryChangeDataCaptureResource(dataFactoryChangeDataCaptureResourceId);

            // invoke the operation
            await dataFactoryChangeDataCapture.StartAsync();

            Console.WriteLine($"Succeeded");
        }

        // ChangeDataCapture_Stop
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Stop_ChangeDataCaptureStop()
        {
            // Generated from example definition: specification/datafactory/resource-manager/Microsoft.DataFactory/stable/2018-06-01/examples/ChangeDataCapture_Stop.json
            // this example is just showing the usage of "ChangeDataCapture_Stop" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DataFactoryChangeDataCaptureResource created on azure
            // for more information of creating DataFactoryChangeDataCaptureResource, please refer to the document of DataFactoryChangeDataCaptureResource
            string subscriptionId = "12345678-1234-1234-1234-12345678abc";
            string resourceGroupName = "exampleResourceGroup";
            string factoryName = "exampleFactoryName";
            string changeDataCaptureName = "exampleChangeDataCapture";
            ResourceIdentifier dataFactoryChangeDataCaptureResourceId = DataFactoryChangeDataCaptureResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, factoryName, changeDataCaptureName);
            DataFactoryChangeDataCaptureResource dataFactoryChangeDataCapture = client.GetDataFactoryChangeDataCaptureResource(dataFactoryChangeDataCaptureResourceId);

            // invoke the operation
            await dataFactoryChangeDataCapture.StopAsync();

            Console.WriteLine($"Succeeded");
        }

        // ChangeDataCapture_Start
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Status_ChangeDataCaptureStart()
        {
            // Generated from example definition: specification/datafactory/resource-manager/Microsoft.DataFactory/stable/2018-06-01/examples/ChangeDataCapture_Status.json
            // this example is just showing the usage of "ChangeDataCapture_Status" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DataFactoryChangeDataCaptureResource created on azure
            // for more information of creating DataFactoryChangeDataCaptureResource, please refer to the document of DataFactoryChangeDataCaptureResource
            string subscriptionId = "12345678-1234-1234-1234-12345678abc";
            string resourceGroupName = "exampleResourceGroup";
            string factoryName = "exampleFactoryName";
            string changeDataCaptureName = "exampleChangeDataCapture";
            ResourceIdentifier dataFactoryChangeDataCaptureResourceId = DataFactoryChangeDataCaptureResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, factoryName, changeDataCaptureName);
            DataFactoryChangeDataCaptureResource dataFactoryChangeDataCapture = client.GetDataFactoryChangeDataCaptureResource(dataFactoryChangeDataCaptureResourceId);

            // invoke the operation
            string result = await dataFactoryChangeDataCapture.StatusAsync();

            Console.WriteLine($"Succeeded: {result}");
        }
    }
}
