// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Datadog.Models
{
    /// <summary> The DatadogSingleSignOnProperties. </summary>
    public partial class DatadogSingleSignOnProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DatadogSingleSignOnProperties"/>. </summary>
        public DatadogSingleSignOnProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DatadogSingleSignOnProperties"/>. </summary>
        /// <param name="provisioningState"></param>
        /// <param name="singleSignOnState"> Various states of the SSO resource. </param>
        /// <param name="enterpriseAppId"> The Id of the Enterprise App used for Single sign-on. </param>
        /// <param name="singleSignOnUri"> The login URL specific to this Datadog Organization. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DatadogSingleSignOnProperties(ProvisioningState? provisioningState, SingleSignOnState? singleSignOnState, string enterpriseAppId, Uri singleSignOnUri, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ProvisioningState = provisioningState;
            SingleSignOnState = singleSignOnState;
            EnterpriseAppId = enterpriseAppId;
            SingleSignOnUri = singleSignOnUri;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets the provisioning state. </summary>
        public ProvisioningState? ProvisioningState { get; }
        /// <summary> Various states of the SSO resource. </summary>
        public SingleSignOnState? SingleSignOnState { get; set; }
        /// <summary> The Id of the Enterprise App used for Single sign-on. </summary>
        public string EnterpriseAppId { get; set; }
        /// <summary> The login URL specific to this Datadog Organization. </summary>
        public Uri SingleSignOnUri { get; }
    }
}
