// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Datadog.Models
{
    /// <summary> The parameters for a PATCH request to a monitor resource. </summary>
    public partial class DatadogMonitorResourcePatch
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DatadogMonitorResourcePatch"/>. </summary>
        public DatadogMonitorResourcePatch()
        {
            Tags = new ChangeTrackingDictionary<string, string>();
        }

        /// <summary> Initializes a new instance of <see cref="DatadogMonitorResourcePatch"/>. </summary>
        /// <param name="properties"> The set of properties that can be update in a PATCH request to a monitor resource. </param>
        /// <param name="tags"> The new tags of the monitor resource. </param>
        /// <param name="sku"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DatadogMonitorResourcePatch(MonitorUpdateProperties properties, IDictionary<string, string> tags, ResourceSku sku, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Properties = properties;
            Tags = tags;
            Sku = sku;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The set of properties that can be update in a PATCH request to a monitor resource. </summary>
        internal MonitorUpdateProperties Properties { get; set; }
        /// <summary> Flag specifying if the resource monitoring is enabled or disabled. </summary>
        public MonitoringStatus? MonitorUpdateMonitoringStatus
        {
            get => Properties is null ? default : Properties.MonitoringStatus;
            set
            {
                if (Properties is null)
                    Properties = new MonitorUpdateProperties();
                Properties.MonitoringStatus = value;
            }
        }

        /// <summary> The new tags of the monitor resource. </summary>
        public IDictionary<string, string> Tags { get; }
        /// <summary> Gets or sets the sku. </summary>
        internal ResourceSku Sku { get; set; }
        /// <summary> Name of the SKU. </summary>
        public string SkuName
        {
            get => Sku is null ? default : Sku.Name;
            set => Sku = new ResourceSku(value);
        }
    }
}
