// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Datadog.Models
{
    /// <summary> The DatadogHostMetadata. </summary>
    public partial class DatadogHostMetadata
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DatadogHostMetadata"/>. </summary>
        internal DatadogHostMetadata()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DatadogHostMetadata"/>. </summary>
        /// <param name="agentVersion"> The agent version. </param>
        /// <param name="installMethod"></param>
        /// <param name="logsAgent"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DatadogHostMetadata(string agentVersion, DatadogInstallMethod installMethod, DatadogLogsAgent logsAgent, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            AgentVersion = agentVersion;
            InstallMethod = installMethod;
            LogsAgent = logsAgent;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The agent version. </summary>
        public string AgentVersion { get; }
        /// <summary> Gets the install method. </summary>
        public DatadogInstallMethod InstallMethod { get; }
        /// <summary> Gets the logs agent. </summary>
        internal DatadogLogsAgent LogsAgent { get; }
        /// <summary> The transport. </summary>
        public string LogsAgentTransport
        {
            get => LogsAgent?.Transport;
        }
    }
}
