// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Datadog
{
    internal class DatadogMonitorResourceOperationSource : IOperationSource<DatadogMonitorResource>
    {
        private readonly ArmClient _client;

        internal DatadogMonitorResourceOperationSource(ArmClient client)
        {
            _client = client;
        }

        DatadogMonitorResource IOperationSource<DatadogMonitorResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = DatadogMonitorResourceData.DeserializeDatadogMonitorResourceData(document.RootElement);
            return new DatadogMonitorResource(_client, data);
        }

        async ValueTask<DatadogMonitorResource> IOperationSource<DatadogMonitorResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = DatadogMonitorResourceData.DeserializeDatadogMonitorResourceData(document.RootElement);
            return new DatadogMonitorResource(_client, data);
        }
    }
}
