// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using Azure.Core;

namespace Azure.ResourceManager.Datadog.Mocking
{
    /// <summary> A class to add extension methods to ArmClient. </summary>
    public partial class MockableDatadogArmClient : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableDatadogArmClient"/> class for mocking. </summary>
        protected MockableDatadogArmClient()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableDatadogArmClient"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableDatadogArmClient(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        internal MockableDatadogArmClient(ArmClient client) : this(client, ResourceIdentifier.Root)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// Gets an object representing a <see cref="DatadogMonitorResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DatadogMonitorResource.CreateResourceIdentifier" /> to create a <see cref="DatadogMonitorResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DatadogMonitorResource"/> object. </returns>
        public virtual DatadogMonitorResource GetDatadogMonitorResource(ResourceIdentifier id)
        {
            DatadogMonitorResource.ValidateResourceId(id);
            return new DatadogMonitorResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="MonitoringTagRuleResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="MonitoringTagRuleResource.CreateResourceIdentifier" /> to create a <see cref="MonitoringTagRuleResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="MonitoringTagRuleResource"/> object. </returns>
        public virtual MonitoringTagRuleResource GetMonitoringTagRuleResource(ResourceIdentifier id)
        {
            MonitoringTagRuleResource.ValidateResourceId(id);
            return new MonitoringTagRuleResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DatadogSingleSignOnResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DatadogSingleSignOnResource.CreateResourceIdentifier" /> to create a <see cref="DatadogSingleSignOnResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DatadogSingleSignOnResource"/> object. </returns>
        public virtual DatadogSingleSignOnResource GetDatadogSingleSignOnResource(ResourceIdentifier id)
        {
            DatadogSingleSignOnResource.ValidateResourceId(id);
            return new DatadogSingleSignOnResource(Client, id);
        }
    }
}
