// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataBoxEdge.Models
{
    /// <summary> List of VM sizes being checked for creation on appliance along with corresponding result. </summary>
    public partial class VmPlacementRequestResult
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="VmPlacementRequestResult"/>. </summary>
        public VmPlacementRequestResult()
        {
            VmSize = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="VmPlacementRequestResult"/>. </summary>
        /// <param name="vmSize"> List of VM sizes being checked. </param>
        /// <param name="isFeasible"> Boolean value indicating if the VM(s) in VmSize can be created. </param>
        /// <param name="messageCode"> MessageCode indicating reason for success or failure. </param>
        /// <param name="message"> Localized message to be displayed to the user to explain the check result. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal VmPlacementRequestResult(IList<string> vmSize, bool? isFeasible, string messageCode, string message, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            VmSize = vmSize;
            IsFeasible = isFeasible;
            MessageCode = messageCode;
            Message = message;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> List of VM sizes being checked. </summary>
        public IList<string> VmSize { get; }
        /// <summary> Boolean value indicating if the VM(s) in VmSize can be created. </summary>
        public bool? IsFeasible { get; set; }
        /// <summary> MessageCode indicating reason for success or failure. </summary>
        public string MessageCode { get; set; }
        /// <summary> Localized message to be displayed to the user to explain the check result. </summary>
        public string Message { get; set; }
    }
}
