// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataBoxEdge.Models
{
    /// <summary> Current stage of the update operation. </summary>
    public readonly partial struct UpdateOperationStage : IEquatable<UpdateOperationStage>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="UpdateOperationStage"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public UpdateOperationStage(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "Unknown";
        private const string InitialValue = "Initial";
        private const string ScanStartedValue = "ScanStarted";
        private const string ScanCompleteValue = "ScanComplete";
        private const string ScanFailedValue = "ScanFailed";
        private const string DownloadStartedValue = "DownloadStarted";
        private const string DownloadCompleteValue = "DownloadComplete";
        private const string DownloadFailedValue = "DownloadFailed";
        private const string InstallStartedValue = "InstallStarted";
        private const string InstallCompleteValue = "InstallComplete";
        private const string InstallFailedValue = "InstallFailed";
        private const string RebootInitiatedValue = "RebootInitiated";
        private const string SuccessValue = "Success";
        private const string FailureValue = "Failure";
        private const string RescanStartedValue = "RescanStarted";
        private const string RescanCompleteValue = "RescanComplete";
        private const string RescanFailedValue = "RescanFailed";

        /// <summary> Unknown. </summary>
        public static UpdateOperationStage Unknown { get; } = new UpdateOperationStage(UnknownValue);
        /// <summary> Initial. </summary>
        public static UpdateOperationStage Initial { get; } = new UpdateOperationStage(InitialValue);
        /// <summary> ScanStarted. </summary>
        public static UpdateOperationStage ScanStarted { get; } = new UpdateOperationStage(ScanStartedValue);
        /// <summary> ScanComplete. </summary>
        public static UpdateOperationStage ScanComplete { get; } = new UpdateOperationStage(ScanCompleteValue);
        /// <summary> ScanFailed. </summary>
        public static UpdateOperationStage ScanFailed { get; } = new UpdateOperationStage(ScanFailedValue);
        /// <summary> DownloadStarted. </summary>
        public static UpdateOperationStage DownloadStarted { get; } = new UpdateOperationStage(DownloadStartedValue);
        /// <summary> DownloadComplete. </summary>
        public static UpdateOperationStage DownloadComplete { get; } = new UpdateOperationStage(DownloadCompleteValue);
        /// <summary> DownloadFailed. </summary>
        public static UpdateOperationStage DownloadFailed { get; } = new UpdateOperationStage(DownloadFailedValue);
        /// <summary> InstallStarted. </summary>
        public static UpdateOperationStage InstallStarted { get; } = new UpdateOperationStage(InstallStartedValue);
        /// <summary> InstallComplete. </summary>
        public static UpdateOperationStage InstallComplete { get; } = new UpdateOperationStage(InstallCompleteValue);
        /// <summary> InstallFailed. </summary>
        public static UpdateOperationStage InstallFailed { get; } = new UpdateOperationStage(InstallFailedValue);
        /// <summary> RebootInitiated. </summary>
        public static UpdateOperationStage RebootInitiated { get; } = new UpdateOperationStage(RebootInitiatedValue);
        /// <summary> Success. </summary>
        public static UpdateOperationStage Success { get; } = new UpdateOperationStage(SuccessValue);
        /// <summary> Failure. </summary>
        public static UpdateOperationStage Failure { get; } = new UpdateOperationStage(FailureValue);
        /// <summary> RescanStarted. </summary>
        public static UpdateOperationStage RescanStarted { get; } = new UpdateOperationStage(RescanStartedValue);
        /// <summary> RescanComplete. </summary>
        public static UpdateOperationStage RescanComplete { get; } = new UpdateOperationStage(RescanCompleteValue);
        /// <summary> RescanFailed. </summary>
        public static UpdateOperationStage RescanFailed { get; } = new UpdateOperationStage(RescanFailedValue);
        /// <summary> Determines if two <see cref="UpdateOperationStage"/> values are the same. </summary>
        public static bool operator ==(UpdateOperationStage left, UpdateOperationStage right) => left.Equals(right);
        /// <summary> Determines if two <see cref="UpdateOperationStage"/> values are not the same. </summary>
        public static bool operator !=(UpdateOperationStage left, UpdateOperationStage right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="UpdateOperationStage"/>. </summary>
        public static implicit operator UpdateOperationStage(string value) => new UpdateOperationStage(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is UpdateOperationStage other && Equals(other);
        /// <inheritdoc />
        public bool Equals(UpdateOperationStage other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
