// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataBoxEdge.Models
{
    /// <summary> Details about the download progress of update. </summary>
    public partial class UpdateDownloadProgress
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="UpdateDownloadProgress"/>. </summary>
        internal UpdateDownloadProgress()
        {
        }

        /// <summary> Initializes a new instance of <see cref="UpdateDownloadProgress"/>. </summary>
        /// <param name="downloadPhase"> The download phase. </param>
        /// <param name="percentComplete"> Percentage of completion. </param>
        /// <param name="totalBytesToDownload"> Total bytes to download. </param>
        /// <param name="totalBytesDownloaded"> Total bytes downloaded. </param>
        /// <param name="numberOfUpdatesToDownload"> Number of updates to download. </param>
        /// <param name="numberOfUpdatesDownloaded"> Number of updates downloaded. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal UpdateDownloadProgress(DataBoxEdgeDownloadPhase? downloadPhase, int? percentComplete, double? totalBytesToDownload, double? totalBytesDownloaded, int? numberOfUpdatesToDownload, int? numberOfUpdatesDownloaded, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            DownloadPhase = downloadPhase;
            PercentComplete = percentComplete;
            TotalBytesToDownload = totalBytesToDownload;
            TotalBytesDownloaded = totalBytesDownloaded;
            NumberOfUpdatesToDownload = numberOfUpdatesToDownload;
            NumberOfUpdatesDownloaded = numberOfUpdatesDownloaded;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The download phase. </summary>
        public DataBoxEdgeDownloadPhase? DownloadPhase { get; }
        /// <summary> Percentage of completion. </summary>
        public int? PercentComplete { get; }
        /// <summary> Total bytes to download. </summary>
        public double? TotalBytesToDownload { get; }
        /// <summary> Total bytes downloaded. </summary>
        public double? TotalBytesDownloaded { get; }
        /// <summary> Number of updates to download. </summary>
        public int? NumberOfUpdatesToDownload { get; }
        /// <summary> Number of updates downloaded. </summary>
        public int? NumberOfUpdatesDownloaded { get; }
    }
}
