// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.DataBoxEdge.Models
{
    /// <summary> The request object for trigger support package. </summary>
    public partial class TriggerSupportPackageContent : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="TriggerSupportPackageContent"/>. </summary>
        public TriggerSupportPackageContent()
        {
        }

        /// <summary> Initializes a new instance of <see cref="TriggerSupportPackageContent"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="minimumTimeStamp"> MinimumTimeStamp from where logs need to be collected. </param>
        /// <param name="maximumTimeStamp"> Start of the timespan of the log collection. </param>
        /// <param name="include">
        /// Type of files, which need to be included in the logs
        /// This will contain the type of logs (Default/DefaultWithDumps/None/All/DefaultWithArchived)
        /// or a comma separated list of log types that are required
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal TriggerSupportPackageContent(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, DateTimeOffset? minimumTimeStamp, DateTimeOffset? maximumTimeStamp, string include, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            MinimumTimeStamp = minimumTimeStamp;
            MaximumTimeStamp = maximumTimeStamp;
            Include = include;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> MinimumTimeStamp from where logs need to be collected. </summary>
        public DateTimeOffset? MinimumTimeStamp { get; set; }
        /// <summary> Start of the timespan of the log collection. </summary>
        public DateTimeOffset? MaximumTimeStamp { get; set; }
        /// <summary>
        /// Type of files, which need to be included in the logs
        /// This will contain the type of logs (Default/DefaultWithDumps/None/All/DefaultWithArchived)
        /// or a comma separated list of log types that are required
        /// </summary>
        public string Include { get; set; }
    }
}
