// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataBoxEdge.Models
{
    /// <summary> Current status of the share. </summary>
    public readonly partial struct ShareStatus : IEquatable<ShareStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ShareStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ShareStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OfflineValue = "Offline";
        private const string UnknownValue = "Unknown";
        private const string OKValue = "OK";
        private const string UpdatingValue = "Updating";
        private const string NeedsAttentionValue = "NeedsAttention";

        /// <summary> Offline. </summary>
        public static ShareStatus Offline { get; } = new ShareStatus(OfflineValue);
        /// <summary> Unknown. </summary>
        public static ShareStatus Unknown { get; } = new ShareStatus(UnknownValue);
        /// <summary> OK. </summary>
        public static ShareStatus OK { get; } = new ShareStatus(OKValue);
        /// <summary> Updating. </summary>
        public static ShareStatus Updating { get; } = new ShareStatus(UpdatingValue);
        /// <summary> NeedsAttention. </summary>
        public static ShareStatus NeedsAttention { get; } = new ShareStatus(NeedsAttentionValue);
        /// <summary> Determines if two <see cref="ShareStatus"/> values are the same. </summary>
        public static bool operator ==(ShareStatus left, ShareStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ShareStatus"/> values are not the same. </summary>
        public static bool operator !=(ShareStatus left, ShareStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ShareStatus"/>. </summary>
        public static implicit operator ShareStatus(string value) => new ShareStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ShareStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ShareStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
