// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataBoxEdge.Models
{
    /// <summary> Type of access to be allowed on the share for this user. </summary>
    public readonly partial struct ShareAccessType : IEquatable<ShareAccessType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ShareAccessType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ShareAccessType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ChangeValue = "Change";
        private const string ReadValue = "Read";
        private const string CustomValue = "Custom";

        /// <summary> Change. </summary>
        public static ShareAccessType Change { get; } = new ShareAccessType(ChangeValue);
        /// <summary> Read. </summary>
        public static ShareAccessType Read { get; } = new ShareAccessType(ReadValue);
        /// <summary> Custom. </summary>
        public static ShareAccessType Custom { get; } = new ShareAccessType(CustomValue);
        /// <summary> Determines if two <see cref="ShareAccessType"/> values are the same. </summary>
        public static bool operator ==(ShareAccessType left, ShareAccessType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ShareAccessType"/> values are not the same. </summary>
        public static bool operator !=(ShareAccessType left, ShareAccessType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ShareAccessType"/>. </summary>
        public static implicit operator ShareAccessType(string value) => new ShareAccessType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ShareAccessType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ShareAccessType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
