// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.DataBoxEdge.Models
{
    /// <summary> Specifies the mapping between this particular user and the type of access he has on shares on this device. </summary>
    public partial class ShareAccessRight
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ShareAccessRight"/>. </summary>
        /// <param name="shareId"> The share ID. </param>
        /// <param name="accessType"> Type of access to be allowed on the share for this user. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="shareId"/> is null. </exception>
        internal ShareAccessRight(ResourceIdentifier shareId, ShareAccessType accessType)
        {
            Argument.AssertNotNull(shareId, nameof(shareId));

            ShareId = shareId;
            AccessType = accessType;
        }

        /// <summary> Initializes a new instance of <see cref="ShareAccessRight"/>. </summary>
        /// <param name="shareId"> The share ID. </param>
        /// <param name="accessType"> Type of access to be allowed on the share for this user. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ShareAccessRight(ResourceIdentifier shareId, ShareAccessType accessType, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ShareId = shareId;
            AccessType = accessType;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ShareAccessRight"/> for deserialization. </summary>
        internal ShareAccessRight()
        {
        }

        /// <summary> The share ID. </summary>
        public ResourceIdentifier ShareId { get; }
        /// <summary> Type of access to be allowed on the share for this user. </summary>
        public ShareAccessType AccessType { get; }
    }
}
