// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataBoxEdge.Models
{
    /// <summary> Access protocol to be used by the share. </summary>
    public readonly partial struct ShareAccessProtocol : IEquatable<ShareAccessProtocol>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ShareAccessProtocol"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ShareAccessProtocol(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SmbValue = "SMB";
        private const string NfsValue = "NFS";

        /// <summary> SMB. </summary>
        public static ShareAccessProtocol Smb { get; } = new ShareAccessProtocol(SmbValue);
        /// <summary> NFS. </summary>
        public static ShareAccessProtocol Nfs { get; } = new ShareAccessProtocol(NfsValue);
        /// <summary> Determines if two <see cref="ShareAccessProtocol"/> values are the same. </summary>
        public static bool operator ==(ShareAccessProtocol left, ShareAccessProtocol right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ShareAccessProtocol"/> values are not the same. </summary>
        public static bool operator !=(ShareAccessProtocol left, ShareAccessProtocol right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ShareAccessProtocol"/>. </summary>
        public static implicit operator ShareAccessProtocol(string value) => new ShareAccessProtocol(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ShareAccessProtocol other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ShareAccessProtocol other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
