// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataBoxEdge.Models
{
    /// <summary> If provisioned storage is posix compliant. </summary>
    public readonly partial struct PosixComplianceStatus : IEquatable<PosixComplianceStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PosixComplianceStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PosixComplianceStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InvalidValue = "Invalid";
        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";

        /// <summary> Invalid. </summary>
        public static PosixComplianceStatus Invalid { get; } = new PosixComplianceStatus(InvalidValue);
        /// <summary> Enabled. </summary>
        public static PosixComplianceStatus Enabled { get; } = new PosixComplianceStatus(EnabledValue);
        /// <summary> Disabled. </summary>
        public static PosixComplianceStatus Disabled { get; } = new PosixComplianceStatus(DisabledValue);
        /// <summary> Determines if two <see cref="PosixComplianceStatus"/> values are the same. </summary>
        public static bool operator ==(PosixComplianceStatus left, PosixComplianceStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PosixComplianceStatus"/> values are not the same. </summary>
        public static bool operator !=(PosixComplianceStatus left, PosixComplianceStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PosixComplianceStatus"/>. </summary>
        public static implicit operator PosixComplianceStatus(string value) => new PosixComplianceStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PosixComplianceStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PosixComplianceStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
