// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.DataBoxEdge.Models
{
    public partial class NumaNodeInfo : IUtf8JsonSerializable, IJsonModel<NumaNodeInfo>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<NumaNodeInfo>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<NumaNodeInfo>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<NumaNodeInfo>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(NumaNodeInfo)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(NumaNodeIndex))
            {
                writer.WritePropertyName("numaNodeIndex"u8);
                writer.WriteNumberValue(NumaNodeIndex.Value);
            }
            if (Optional.IsDefined(TotalMemoryInMB))
            {
                writer.WritePropertyName("totalMemoryInMb"u8);
                writer.WriteNumberValue(TotalMemoryInMB.Value);
            }
            if (Optional.IsDefined(LogicalCoreCountPerCore))
            {
                writer.WritePropertyName("logicalCoreCountPerCore"u8);
                writer.WriteNumberValue(LogicalCoreCountPerCore.Value);
            }
            if (Optional.IsDefined(EffectiveAvailableMemoryInMB))
            {
                writer.WritePropertyName("effectiveAvailableMemoryInMb"u8);
                writer.WriteNumberValue(EffectiveAvailableMemoryInMB.Value);
            }
            if (Optional.IsCollectionDefined(FreeVCpuIndexesForHpn))
            {
                writer.WritePropertyName("freeVCpuIndexesForHpn"u8);
                writer.WriteStartArray();
                foreach (var item in FreeVCpuIndexesForHpn)
                {
                    writer.WriteNumberValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(VCpuIndexesForHpn))
            {
                writer.WritePropertyName("vCpuIndexesForHpn"u8);
                writer.WriteStartArray();
                foreach (var item in VCpuIndexesForHpn)
                {
                    writer.WriteNumberValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(VCpuIndexesForRoot))
            {
                writer.WritePropertyName("vCpuIndexesForRoot"u8);
                writer.WriteStartArray();
                foreach (var item in VCpuIndexesForRoot)
                {
                    writer.WriteNumberValue(item);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        NumaNodeInfo IJsonModel<NumaNodeInfo>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<NumaNodeInfo>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(NumaNodeInfo)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeNumaNodeInfo(document.RootElement, options);
        }

        internal static NumaNodeInfo DeserializeNumaNodeInfo(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            int? numaNodeIndex = default;
            long? totalMemoryInMb = default;
            int? logicalCoreCountPerCore = default;
            long? effectiveAvailableMemoryInMb = default;
            IList<int> freeVCpuIndexesForHpn = default;
            IList<int> vCpuIndexesForHpn = default;
            IList<int> vCpuIndexesForRoot = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("numaNodeIndex"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    numaNodeIndex = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("totalMemoryInMb"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    totalMemoryInMb = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("logicalCoreCountPerCore"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    logicalCoreCountPerCore = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("effectiveAvailableMemoryInMb"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    effectiveAvailableMemoryInMb = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("freeVCpuIndexesForHpn"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<int> array = new List<int>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetInt32());
                    }
                    freeVCpuIndexesForHpn = array;
                    continue;
                }
                if (property.NameEquals("vCpuIndexesForHpn"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<int> array = new List<int>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetInt32());
                    }
                    vCpuIndexesForHpn = array;
                    continue;
                }
                if (property.NameEquals("vCpuIndexesForRoot"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<int> array = new List<int>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetInt32());
                    }
                    vCpuIndexesForRoot = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new NumaNodeInfo(
                numaNodeIndex,
                totalMemoryInMb,
                logicalCoreCountPerCore,
                effectiveAvailableMemoryInMb,
                freeVCpuIndexesForHpn ?? new ChangeTrackingList<int>(),
                vCpuIndexesForHpn ?? new ChangeTrackingList<int>(),
                vCpuIndexesForRoot ?? new ChangeTrackingList<int>(),
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<NumaNodeInfo>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<NumaNodeInfo>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(NumaNodeInfo)} does not support writing '{options.Format}' format.");
            }
        }

        NumaNodeInfo IPersistableModel<NumaNodeInfo>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<NumaNodeInfo>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeNumaNodeInfo(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(NumaNodeInfo)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<NumaNodeInfo>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
