// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.DataBoxEdge.Models
{
    /// <summary> MEC role. </summary>
    public partial class MecRole : DataBoxEdgeRoleData
    {
        /// <summary> Initializes a new instance of <see cref="MecRole"/>. </summary>
        public MecRole()
        {
            Kind = DataBoxEdgeRoleType.Mec;
        }

        /// <summary> Initializes a new instance of <see cref="MecRole"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="kind"> Role type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="connectionString"> Activation key of the MEC. </param>
        /// <param name="controllerEndpoint"> Controller Endpoint. </param>
        /// <param name="resourceUniqueId"> Unique Id of the Resource. </param>
        /// <param name="roleStatus"> Role status. </param>
        internal MecRole(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, DataBoxEdgeRoleType kind, IDictionary<string, BinaryData> serializedAdditionalRawData, AsymmetricEncryptedSecret connectionString, string controllerEndpoint, string resourceUniqueId, DataBoxEdgeRoleStatus? roleStatus) : base(id, name, resourceType, systemData, kind, serializedAdditionalRawData)
        {
            ConnectionString = connectionString;
            ControllerEndpoint = controllerEndpoint;
            ResourceUniqueId = resourceUniqueId;
            RoleStatus = roleStatus;
            Kind = kind;
        }

        /// <summary> Activation key of the MEC. </summary>
        public AsymmetricEncryptedSecret ConnectionString { get; set; }
        /// <summary> Controller Endpoint. </summary>
        public string ControllerEndpoint { get; set; }
        /// <summary> Unique Id of the Resource. </summary>
        public string ResourceUniqueId { get; set; }
        /// <summary> Role status. </summary>
        public DataBoxEdgeRoleStatus? RoleStatus { get; set; }
    }
}
