// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataBoxEdge.Models
{
    /// <summary> Image repository credential. </summary>
    public partial class ImageRepositoryCredential
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ImageRepositoryCredential"/>. </summary>
        /// <param name="imageRepositoryUri"> Image repository url (e.g.: mcr.microsoft.com). </param>
        /// <param name="userName"> Repository user name. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="imageRepositoryUri"/> or <paramref name="userName"/> is null. </exception>
        public ImageRepositoryCredential(Uri imageRepositoryUri, string userName)
        {
            Argument.AssertNotNull(imageRepositoryUri, nameof(imageRepositoryUri));
            Argument.AssertNotNull(userName, nameof(userName));

            ImageRepositoryUri = imageRepositoryUri;
            UserName = userName;
        }

        /// <summary> Initializes a new instance of <see cref="ImageRepositoryCredential"/>. </summary>
        /// <param name="imageRepositoryUri"> Image repository url (e.g.: mcr.microsoft.com). </param>
        /// <param name="userName"> Repository user name. </param>
        /// <param name="password"> Repository user password. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ImageRepositoryCredential(Uri imageRepositoryUri, string userName, AsymmetricEncryptedSecret password, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ImageRepositoryUri = imageRepositoryUri;
            UserName = userName;
            Password = password;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ImageRepositoryCredential"/> for deserialization. </summary>
        internal ImageRepositoryCredential()
        {
        }

        /// <summary> Image repository url (e.g.: mcr.microsoft.com). </summary>
        public Uri ImageRepositoryUri { get; set; }
        /// <summary> Repository user name. </summary>
        public string UserName { get; set; }
        /// <summary> Repository user password. </summary>
        public AsymmetricEncryptedSecret Password { get; set; }
    }
}
