// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataBoxEdge.Models
{
    /// <summary> Used in activation key generation flow. </summary>
    public partial class GenerateCertResult
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="GenerateCertResult"/>. </summary>
        internal GenerateCertResult()
        {
        }

        /// <summary> Initializes a new instance of <see cref="GenerateCertResult"/>. </summary>
        /// <param name="publicKey">
        /// Gets or sets base64 encoded certificate raw data,
        /// this is the public part needed to be uploaded to cert vault
        /// </param>
        /// <param name="privateKey">
        /// Gets or sets base64 encoded private part of the certificate,
        /// needed to form the activation key
        /// </param>
        /// <param name="expireOn"> Gets or sets expiry time in UTC. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal GenerateCertResult(string publicKey, string privateKey, DateTimeOffset? expireOn, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            PublicKey = publicKey;
            PrivateKey = privateKey;
            ExpireOn = expireOn;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary>
        /// Gets or sets base64 encoded certificate raw data,
        /// this is the public part needed to be uploaded to cert vault
        /// </summary>
        public string PublicKey { get; }
        /// <summary>
        /// Gets or sets base64 encoded private part of the certificate,
        /// needed to form the activation key
        /// </summary>
        public string PrivateKey { get; }
        /// <summary> Gets or sets expiry time in UTC. </summary>
        public DateTimeOffset? ExpireOn { get; }
    }
}
