// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.DataBoxEdge.Models
{
    public partial class EdgeProfileSubscription : IUtf8JsonSerializable, IJsonModel<EdgeProfileSubscription>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<EdgeProfileSubscription>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<EdgeProfileSubscription>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<EdgeProfileSubscription>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(EdgeProfileSubscription)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(RegistrationId))
            {
                writer.WritePropertyName("registrationId"u8);
                writer.WriteStringValue(RegistrationId.Value);
            }
            if (Optional.IsDefined(Id))
            {
                writer.WritePropertyName("id"u8);
                writer.WriteStringValue(Id);
            }
            if (Optional.IsDefined(State))
            {
                writer.WritePropertyName("state"u8);
                writer.WriteStringValue(State.Value.ToString());
            }
            if (Optional.IsDefined(RegistrationDate))
            {
                writer.WritePropertyName("registrationDate"u8);
                writer.WriteStringValue(RegistrationDate);
            }
            if (Optional.IsDefined(SubscriptionId))
            {
                writer.WritePropertyName("subscriptionId"u8);
                writer.WriteStringValue(SubscriptionId);
            }
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(TenantId))
            {
                writer.WritePropertyName("tenantId"u8);
                writer.WriteStringValue(TenantId.Value);
            }
            if (Optional.IsDefined(LocationPlacementId))
            {
                writer.WritePropertyName("locationPlacementId"u8);
                writer.WriteStringValue(LocationPlacementId);
            }
            if (Optional.IsDefined(QuotaId))
            {
                writer.WritePropertyName("quotaId"u8);
                writer.WriteStringValue(QuotaId);
            }
            if (Optional.IsDefined(SerializedDetails))
            {
                writer.WritePropertyName("serializedDetails"u8);
                writer.WriteStringValue(SerializedDetails);
            }
            if (Optional.IsCollectionDefined(RegisteredFeatures))
            {
                writer.WritePropertyName("registeredFeatures"u8);
                writer.WriteStartArray();
                foreach (var item in RegisteredFeatures)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            writer.WriteEndObject();
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        EdgeProfileSubscription IJsonModel<EdgeProfileSubscription>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<EdgeProfileSubscription>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(EdgeProfileSubscription)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeEdgeProfileSubscription(document.RootElement, options);
        }

        internal static EdgeProfileSubscription DeserializeEdgeProfileSubscription(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            Guid? registrationId = default;
            ResourceIdentifier id = default;
            DataBoxEdgeSubscriptionState? state = default;
            string registrationDate = default;
            string subscriptionId = default;
            Guid? tenantId = default;
            string locationPlacementId = default;
            string quotaId = default;
            string serializedDetails = default;
            IReadOnlyList<SubscriptionRegisteredFeatures> registeredFeatures = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("registrationId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    registrationId = property.Value.GetGuid();
                    continue;
                }
                if (property.NameEquals("id"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("state"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    state = new DataBoxEdgeSubscriptionState(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("registrationDate"u8))
                {
                    registrationDate = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("subscriptionId"u8))
                {
                    subscriptionId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("tenantId"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            tenantId = property0.Value.GetGuid();
                            continue;
                        }
                        if (property0.NameEquals("locationPlacementId"u8))
                        {
                            locationPlacementId = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("quotaId"u8))
                        {
                            quotaId = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("serializedDetails"u8))
                        {
                            serializedDetails = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("registeredFeatures"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<SubscriptionRegisteredFeatures> array = new List<SubscriptionRegisteredFeatures>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(SubscriptionRegisteredFeatures.DeserializeSubscriptionRegisteredFeatures(item, options));
                            }
                            registeredFeatures = array;
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new EdgeProfileSubscription(
                registrationId,
                id,
                state,
                registrationDate,
                subscriptionId,
                tenantId,
                locationPlacementId,
                quotaId,
                serializedDetails,
                registeredFeatures ?? new ChangeTrackingList<SubscriptionRegisteredFeatures>(),
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<EdgeProfileSubscription>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<EdgeProfileSubscription>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(EdgeProfileSubscription)} does not support writing '{options.Format}' format.");
            }
        }

        EdgeProfileSubscription IPersistableModel<EdgeProfileSubscription>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<EdgeProfileSubscription>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeEdgeProfileSubscription(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(EdgeProfileSubscription)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<EdgeProfileSubscription>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
